import expect from 'expect.js';
import { shallow } from 'enzyme';
import sinon from 'sinon';
import Client from '../client';

describe('ingest client', () => {
  let dummyIngestionConfig;
  let filteredIngestionConfig;
  let httpClientMock;
  let client;
  const getHttpClientMock = () => {
    if (!httpClientMock) {
      httpClientMock = sinon.mock();
    }
    return httpClientMock;
  };
  const getClient = () => {
    if (!client) {
      client = new Client('', getHttpClientMock(), { checkApiAvailability: () => false });
    }
    return client;
  };
  beforeEach(() => {
    getHttpClientMock().reset();
    dummyIngestionConfig = {
      datasource: 'pg96',
      query: 'SELECT * FROM events',
      target: 'my-index',
      strategy: 'REPLACE',
      staging_prefix: '',
      pk_field: 'id',
      mapping: {
      },
      pipeline: {
        description: 'Converts long to date and adds summary',
        processors: [
          {
            script: {
              source: 'ctx.date_formatted =  new Date(ctx.occurred)',
              lang: 'painless',
              params: {
                param_c: 10
              }
            }
          },
          {
            set: {
              field: 'summary',
              value: 'Happened in {{location}} at {{date_formatted}}'
            }
          }
        ]
      },
      transforms: [
        {
          input: [
            {
              source: 'value'
            }
          ],
          output: 'value',
          mapping: {
            type: 'long'
          }
        }
      ],
      schedule: '0 15 10 ? * *',
      enable_scheduler: false,
      batch_size: null,
      description: '',
      removed_fields: [
      ],
      virtual_index: ''
    };
    filteredIngestionConfig = {
      datasource: 'pg96',
      query: 'SELECT * FROM events',
      target: 'my-index',
      strategy: 'REPLACE',
      pk_field: 'id',
      mapping: {
      },
      pipeline: {
        description: 'Converts long to date and adds summary',
        processors: [
          {
            script: {
              source: 'ctx.date_formatted =  new Date(ctx.occurred)',
              lang: 'painless',
              params: {
                param_c: 10
              }
            }
          },
          {
            set: {
              field: 'summary',
              value: 'Happened in {{location}} at {{date_formatted}}'
            }
          }
        ]
      },
      transforms: [
        {
          input: [
            {
              source: 'value'
            }
          ],
          output: 'value',
          mapping: {
            type: 'long'
          }
        }
      ],
      schedule: '0 15 10 ? * *',
      enable_scheduler: false,
      removed_fields: [
      ]
    };
  });
  it('saveConfiguration filters invalid job fields', async () => {
    const id = 'some-config-id';
    const extraField = 'should-not-exist';
    getHttpClientMock().returns(Promise.resolve({
      data: {
        acknowledged: true
      }
    }));
    const client = getClient();
    await client.saveConfiguration(id, {
      ...dummyIngestionConfig,
      ...{
        id,
        extraField
      }
    });
    expect(getHttpClientMock().calledOnce).to.be(true);
    const configBody = getHttpClientMock().getCall(0).args[0].data.ingest;
    expect(configBody).to.eql(filteredIngestionConfig);
  });
});