/* eslint-disable import/no-unresolved */
// NOTE: disabled as the resolver is not usable at the moment, might be forked as long as upstream is < 6.3

import Ui from './ui';
import React from 'react';
import { HashRouter } from 'react-router-dom';
import { uiModules } from 'ui/modules';
import chrome from 'ui/chrome';
import { render, unmountComponentAtNode } from 'react-dom';
import 'whatwg-fetch';

import 'plugins/investigate_core/management/sections/kibi_datasources/services/jdbc_datasources';
import 'ui/autoload/all';
import '@elastic/eui/dist/eui_theme_k6_light.css';
import './themes/default.css'; // no sass, check if loader could be added to main repo.
import './sections/xlsx/less/main.less';
import { configService } from './shared_components';
import XLSXClient from './sections/xlsx/services/xlsx_client.js';

const app = uiModules.get('apps/ingest');

app.config($locationProvider => {
  $locationProvider.html5Mode({
    enabled: false,
    requireBase: false,
    rewriteLinks: false,
  });
});

/* TODO: this would be useful if upstream synced with >= 6.3, might be made conditional if ingestion becomes standalone.
app.config(stateManagementConfigProvider =>
  stateManagementConfigProvider.disable()
);
*/

function RootController($scope, $element, $injector, config, createNotifier, $http,
  elasticsearchPlugins) {
  configService(config); //Initialize ConfigService
  XLSXClient.instantiateClient($http); //Initialize XLSXClient
  const domNode = $element[0];
  const renderApp = function () {
    const federateResolver = $injector.get('federateResolver');
    const jdbcDatasources = $injector.get('jdbcDatasources');

    render(
      <HashRouter>
        <Ui
          createNotifier={createNotifier}
          chrome={chrome}
          httpClient={$http}
          injector={$injector}
          jdbcDatasources={jdbcDatasources}
          federateResolver={federateResolver}
        />
      </HashRouter>,
      domNode
    );
  };
  elasticsearchPlugins.init().then(() => {
    renderApp();
  });
  $scope.$on('$destroy', () => unmountComponentAtNode(domNode));
}

chrome.setRootController('app', RootController);
