//Start - Test Data for getCustomTransformations
const multiValuedField = {
  transformation: {
    input: "multiValuedField",
    transform: "split",
    mapping: "{\"type\":\"long\"}",
    mappingObject: {
      type: "long"
    },
    mappingOption: "",
    output: "multiValuedField"
  },
  mappingItem: {
    sanitizedFieldName: "multiValuedField"
  }
};
const getCustomTransformationsTests = [
  {
    description: 'Recognizes custom transformations when - same output name as returned from datasource',
    args: [
      [
        {
          input: "autoincfield",
          transform: "copy",
          mapping: "{\"type\":\"long\"}",
          mappingObject: {
            type: "long"
          },
          mappingOption: "",
          output: "autoincfield"
        },
        multiValuedField.transformation
      ],
      [
        {
          sanitizedFieldName: "autoincfield"
        },
        multiValuedField.mappingItem
      ]
    ],
    expected: [
      multiValuedField.transformation
    ]
  }
];
//End - Test Data for getCustomTransformations
export {
  getCustomTransformationsTests
};