import ConfigurationsHeader from './header';
import React from 'react';
import PropTypes from 'prop-types';
import Section from '../section';
import {
  JobsTable
} from './jobs_table';

import {
  EuiSpacer,
  EuiTitle
} from '@elastic/eui';

export default class Configurations extends Section {

  constructor(props) {
    document.title = 'Datasource Reflection Jobs - Siren';
    super(props);
  }

  fetchJobs = async () => {
    return {
      jobs: await this.props.client.fetchConfigurations()
    };
  }

  renderHeader() {
    return (
      <ConfigurationsHeader
        sections={this.props.sections}
        currentSection={this.props.currentSection}
        displayNew={true}
        displaySave={false}
      />
    );
  }

  renderConfigurations() {
    return (
      <React.Fragment>
        <EuiSpacer size="m" />
        <JobsTable
          fetchJobs={this.fetchJobs}
          hasActions={true}
          showToolbar={true}
          createNotifier={this.props.createNotifier}
          client={this.props.client}
        />
      </React.Fragment>
    );
  }

  renderSection() {
    return (
      <React.Fragment>
        <EuiTitle size="m">
          <h1>Datasource Reflection Jobs</h1>
        </EuiTitle>
        {this.renderConfigurations()}
      </React.Fragment>
    );
  }
}

Configurations.propTypes = {
  createNotifier: PropTypes.func.isRequired,
  client: PropTypes.object.isRequired,
  sections: PropTypes.arrayOf(
    PropTypes.shape({
      href: PropTypes.string.isRequired,
      id: PropTypes.string.isRequired,
      name: PropTypes.oneOfType([
        PropTypes.element,
        PropTypes.string
      ]).isRequired
    })
  ).isRequired,
  currentSection: PropTypes.string.isRequired
};