import React from 'react';
import PropTypes from "prop-types";
import {
  EuiBasicTable,
  EuiColorPicker,
  EuiFieldText,
  EuiCallOut
} from '@elastic/eui';
import {
  RenderRelationsPath
} from './helper_components';

const  ConfigureSavedSearches = (props) => {
  const COLUMNS = [
    {
      name: 'Node',
      field: 'nodeName'
    },
    {
      name: 'Search Name',
      render: item => {
        return (
          <EuiFieldText
            value={item.savedSearch}
            onChange={e => {
              item.savedSearch = e.target.value;
              props.onItemChange(item);
            }}
          />
        );
      }
    },
    {
      name: 'Color',
      render: (item) => {
        return (
          <EuiColorPicker
            color={item.color}
            onChange={newValue => {
              item.color = newValue;
              props.onItemChange(item);
            }}
          />
        );
      }
    },
    {
      name: 'Icon',
      render: ({ icon, color }) => {
        return (
          <span className={`entity-icon kuiIcon ${icon}`} style={{ color }}/>
        );
      }
    },
    {
      name: 'Relation',
      render: ({ relations, nodeName }) =>
        <RenderRelationsPath relations={relations} nodeName={nodeName} />
    }
  ];
  return (
    <React.Fragment>
      <EuiCallOut
        size="s"
        title="Any existing searches with the same name would be updated."
        iconType="pin"
      />
      <EuiBasicTable
        items={props.indexEntitiesList}
        itemId="nodeName"
        columns={COLUMNS}
      />
    </React.Fragment>
  );
};

ConfigureSavedSearches.propTypes = {
  indexEntitiesList: PropTypes.arrayOf(
    PropTypes.shape({
      color: PropTypes.string.isRequired,
      es: PropTypes.string.isRequired,
      icon: PropTypes.string.isRequired,
      jobId: PropTypes.string.isRequired,
      nodeName: PropTypes.string.isRequired,
      label: PropTypes.string.isRequired,
      savedSearch: PropTypes.string.isRequired,
      inverseLabel: PropTypes.string,
      relations: PropTypes.arrayOf(
        PropTypes.exact({
          startNode: PropTypes.string,
          endNode: PropTypes.string,
        })
      )
    })
  ).isRequired,
  onItemChange: PropTypes.func.isRequired
};

export {
  ConfigureSavedSearches
};