import React, { Component } from 'react';
import PropTypes from 'prop-types';
import {
  EuiBasicTable,
  EuiCallOut,
  EuiFieldText,
  EuiSelect
} from '@elastic/eui';
import {
  RenderRelationsPath
} from './helper_components';

class ConfirmReflectionJobs extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
    this.columns = [
      {
        name: 'Node Name',
        field: 'nodeName'
      },
      {
        name: 'Job Name',
        render: ({ jobName }) => {
          return (
            <EuiFieldText
              value={jobName}
              readOnly
            />
          );
        }
      },
      {
        name: 'Primary Key',
        render: ({ nodeName, properties, primaryKey }) => {
          return (
            <EuiSelect
              options={properties}
              value={primaryKey}
              onChange={({ target }) => this.props.changeJobData(nodeName, 'primaryKey', target.value)}
            />
          );
        }
      },
      {
        name: 'Target Index',
        render: ({ targetIndex }) => {
          return (
            <EuiFieldText
              value={targetIndex}
              readOnly
            />
          );
        }
      },
      {
        name: 'Relation',
        render: ({ relations, nodeName }) =>
          <RenderRelationsPath relations={relations} nodeName={nodeName} />
      }
    ];
  }

  render() {
    return (
      <React.Fragment>
        <EuiCallOut
          size="s"
          title="Any existing jobs with the same name would be overwritten."
          iconType="pin"
        />
        <EuiBasicTable
          items={this.props.reflectionJobs}
          columns={this.columns}
        />
      </React.Fragment>
    );
  }
}

export {
  ConfirmReflectionJobs
};

ConfirmReflectionJobs.propTypes = {
  reflectionJobs: PropTypes.arrayOf(
    PropTypes.shape({
      nodeName: PropTypes.string.isRequired,
      jobName: PropTypes.string.isRequired,
      targetIndex: PropTypes.string.isRequired,
      primaryKey: PropTypes.string.isRequired,
      properties: PropTypes.arrayOf(
        PropTypes.exact({
          value: PropTypes.string.isRequired,
          text: PropTypes.string.isRequired
        })
      ).isRequired,
      relations: PropTypes.arrayOf(
        PropTypes.exact({
          startNode: PropTypes.string,
          endNode: PropTypes.string,
        })
      )
    })
  ).isRequired,
  changeJobData: PropTypes.func.isRequired,
  toggleConfirmButton: PropTypes.func.isRequired
};