import React from 'react';

const CENTER_ALIGN = {
  marginLeft: 'auto',
  marginRight: 'auto'
};

function RenderRelationsPath({ relations, nodeName }) {
  if (relations && relations.length > 0) {
    return (
      <div>
        {relations.map(({ startNode, endNode }) =>
          <p key={`${startNode}-${endNode}`}>{`${startNode} --> ${nodeName} --> ${endNode}`}</p>)
        }
      </div>
    );
  }
  return <span style={CENTER_ALIGN}>-</span>;
}

export {
  RenderRelationsPath
};