import {
  jsonStringToObject,
  getESType
} from '../../shared_components';

function filterItems(items, removed) {
  let finalItems = items;
  if (removed.length > 0) {
    finalItems = finalItems.filter(ele =>
      removed.findIndex(rem => {
        return rem.label === ele.sanitizedFieldName;
      }) < 0
    );
  }
  return finalItems;
}

function createFieldMapping(item) {
  let mapping = { type: getESType(item.type) };
  if (item.useAdv) {
    mapping = ({ ...mapping,
      ...jsonStringToObject(item.advJson)
    });
  }
  return mapping;
}

function getCustomTransformations(transformations, mappingItems) {
  const customTransformations = [];
  const transHash = transformations.reduce((hash, { output, transform }, index) => {
    hash[output] = { index, transform };
    return hash;
  }, {});
  mappingItems.forEach((mappingElement) => {
    if (transHash[mappingElement.sanitizedFieldName]
      && transHash[mappingElement.sanitizedFieldName].transform === 'copy') {
      delete transHash[mappingElement.sanitizedFieldName];
    }
  });
  for (const key in transHash) {
    if (transHash.hasOwnProperty(key)) {
      customTransformations.push(transformations[transHash[key].index]);
    }
  }
  return customTransformations;
}

function mappingToTransformation(mappingElement) {
  return {
    input: [{
      source: mappingElement.name
    }],
    output: mappingElement.sanitizedFieldName,
    mapping: createFieldMapping(mappingElement)
  };
}

function buildTransformationFromMapping(mapping, existingTransformation = []) {
  const items = filterItems(mapping.items, mapping.removedItems);
  const transformations = existingTransformation.filter(ele =>
    items.findIndex(mappingItem => {
      return mappingItem.sanitizedFieldName === ele.output;
    }) < 0
  );
  for (let i = 0; i < transformations.length; i++) {
    const transform = transformations[i];
    const input = transformations[i].input;
    transform.input = input.split ? input.split(',').map(i => ({ source: i.trim() })) : input;
    transform.mapping = jsonStringToObject(transform.mapping) || {};
    if (transform.transform === 'copy') {
      delete transform.transform;
    }
    delete transform.mappingOption;
    delete transform.mappingObject;
    delete transform.valid;
  }
  for (let i = 0; i < items.length; i++) {
    transformations.push(mappingToTransformation(items[i]));
  }
  return transformations;
}


export {
  buildTransformationFromMapping,
  getCustomTransformations
};