import React from 'react';

import {
  EuiSpacer,
  EuiText
} from '@elastic/eui';


export default [
  {
    value: 'copy',
    inputDisplay: 'Copy',
    dropdownDisplay: (
      <React.Fragment>
        <strong>Copy</strong>
        <EuiSpacer size="xs" />
        <EuiText size="s" color="subdued">
          <p className="euiTextColor--subdued">
            Copies the input field to the target field without applying any transformation.
          </p>
        </EuiText>
      </React.Fragment>
    ),
  },
  {
    value: 'geo_point',
    inputDisplay: 'Geo location',
    dropdownDisplay: (
      <React.Fragment>
        <strong>Geo location</strong>
        <EuiSpacer size="xs" />
        <EuiText size="s" color="subdued">
          <p className="euiTextColor--subdued">
            Takes two numeric input fields (comma separated: `latitude_field,longitude_field`) and
            outputs a string containing a geo location, useful if the output field is of type geo_point.
          </p>
        </EuiText>
      </React.Fragment>
    ),
  },
  {
    value: 'split',
    inputDisplay: 'Split',
    dropdownDisplay: (
      <React.Fragment>
        <strong>Split</strong>
        <EuiSpacer size="xs" />
        <EuiText size="s" color="subdued">
          <p className="euiTextColor--subdued">
            Splits the input field, using comma as the separator, into multiple values.
          </p>
        </EuiText>
      </React.Fragment>
    ),
  }
];
