import React from 'react';
import { shallow } from 'enzyme';
import TransformEditor from './transforms_editor';

const transforms = [
  {
    input: 'AESTDTC',
    transform: 'copy',
    mapping: '{\'type\':\'long\'}',
    mappingObject: {
      type: 'long'
    },
    mappingOption: '',
    output: 'test_long'
  },
  {
    input: 'AESTDTC',
    transform: 'copy',
    mapping: '{\'type\':\'long\'}',
    mappingObject: {
      type: 'long'
    },
    mappingOption: '',
    output: 'second_test_long'
  }
];

test('renders', () => {
  const component = shallow(<TransformEditor
    transforms={transforms}
    onChange={() => 0}
  />);
  expect(component.length).toBe(1);
  expect(component.find('tbody tr').hostNodes().length).toBe(2);
  expect(component).toMatchSnapshot();
});

test('empty render', () => {
  const component = shallow(<TransformEditor
    transforms={[]}
    onChange={() => 0}
  />);
  expect(component.find('tbody tr').hostNodes().length).toBe(0);
  expect(component).toMatchSnapshot();
});