import React from 'react';
import PropTypes from 'prop-types';
import {
  EuiHeader,
  EuiHeaderSection,
  EuiHeaderLinks,
  EuiHeaderLink
} from '@elastic/eui';


export default class Header extends React.Component {

  renderTabs() {
    return this.props.sections.map((tab, index) => {
      return (
        <EuiHeaderLink
          href={tab.href}
          isActive={tab.id === this.props.currentSection}
          key={index}
        >
          {tab.name}
        </EuiHeaderLink>
      );
    });
  }

  renderActions() {
    return [];
  }

  render() {
    return (
      <EuiHeader>
        <EuiHeaderLinks>
          {this.renderTabs()}
        </EuiHeaderLinks>
        <EuiHeaderSection side="right">
          {this.renderActions()}
        </EuiHeaderSection>
      </EuiHeader>
    );
  }

}

Header.propTypes = {
  sections: PropTypes.arrayOf(
    PropTypes.shape({
      href: PropTypes.string.isRequired,
      id: PropTypes.string.isRequired,
      name: PropTypes.oneOfType([
        PropTypes.element,
        PropTypes.string
      ]).isRequired
    })
  ).isRequired,
  currentSection: PropTypes.string.isRequired
};