import React, { Component } from 'react';
import {
  EuiSwitch,
  EuiSpacer,
  EuiFormRow,
  EuiFlexGroup,
  EuiFlexItem,
  EuiFieldText
} from '@elastic/eui';

class CustomId extends Component {
  constructor(props) {
    super(props);
    this.state = {
      on: props.useKbnId,
      kbnIdModel: props.kbnIdModel
    };
    this.clearCustomId = this.clearCustomId.bind(this);
    this.onChange = this.onChange.bind(this);
    this.onToggle = this.onToggle.bind(this);
  }

  clearCustomId() {
    this.setState({ kbnIdModel: '' });
    const c = {
      target: {
        value: ''
      }
    };
    this.props.kbnIdChange(c);
  }

  onToggle(e) {
    this.setState({ on: e.target.checked });
    if (!e.target.checked) {
      setTimeout(this.clearCustomId, 100);
    }
  }

  onChange(e) {
    const value = e.target.value;
    this.setState({ kbnIdModel: value });
    this.props.kbnIdChange({
      target: {
        value
      }
    }, true);
  }

  render() {
    if (this.state.on) {
      return (
        <div>
          <EuiSwitch
            name="switch"
            label="Use Custom storage primary key?"
            checked={this.state.on}
            onChange={this.onToggle}
          />
          <EuiSpacer size="s" />
          <EuiFormRow
            label="Custom storage primary key"
            helpText={'Compose a custom primary key that will be stored in the _id field in the storage,' +
            ' overwriting other records with the same ID. Example "{firstname}_{lastname}:{employee_id}"' +
            ' OR "{__rowNum__} (To use Excel/CSV row number)'}
          >
            <EuiFlexGroup gutterSize="s" alignItems="center">
              <EuiFlexItem grow={false}>
                <EuiFieldText
                  id="kbnID"
                  value={this.state.kbnIdModel}
                  onChange={this.onChange}
                />
              </EuiFlexItem>

              <EuiFlexItem grow={false}>
                <EuiFieldText id="previewKbnID" placeholder="Custom ID preview" value={this.props.kbnIdPreview} readOnly/>
              </EuiFlexItem>
            </EuiFlexGroup>
          </EuiFormRow>
        </div>
      );
    } else {
      return (
        <div>
          <EuiSwitch
            name="switch"
            label="Use Custom storage primary key?"
            checked={this.state.on}
            onChange={this.onToggle}
          />
        </div>
      );
    }
  }
}

export default CustomId;