import React from 'react';
import { mount, shallow } from 'enzyme';
import ErrorTable from './errorTable';
import { renderTests } from './test_data/errorTable';

describe('ErrorTable', () => {
  let componentMount;
  let props;

  const getMount = args => {
    if (!componentMount) {
      componentMount = mount(<ErrorTable {...(args || props)} />);
    }
    return componentMount;
  };

  beforeAll(() => {
    window.requestAnimationFrame = () => {};
  });

  beforeEach(() => {
    if (componentMount) {
      componentMount.unmount();
      componentMount = null;
    }
    props = {};
  });

  describe('renders', () => {
    renderTests.forEach(test => {
      it(test.description, () => {
        const component = getMount(test.props);
        test.expected(component);
      });
    });
  });
});