import React from 'react';

import {
  EuiPageBody,
  EuiPageContent,
  EuiPageContentHeader,
  EuiPageContentBody,
  EuiStepsHorizontal
} from '@elastic/eui';

import StepOne from './stepOne.js';


const Main = (props) => {

  return (
    <EuiPageBody>
      <EuiPageContent>
        <EuiPageContentHeader id="step">
          <EuiStepsHorizontal steps={props.steps} style={{ backgroundColor: 'white' }}/>
        </EuiPageContentHeader>
        <EuiPageContentBody id="main">
          <StepOne nextStep={props.nextStep} savedState={props.savedState}/>
        </EuiPageContentBody>
      </EuiPageContent>
    </EuiPageBody>
  );

};

export default Main;
