import React from 'react';
import {
  EuiCheckbox,
  EuiFieldText,
  EuiSwitch,
  EuiSpacer
} from '@elastic/eui';

function MultiValued(props) {
  const componentNameInItemProperties = 'delimiter';
  let delimiterInput = null;
  if (props.item.multiValued) {
    delimiterInput = (
      <div>
        <EuiSpacer size="s" />
        <EuiFieldText
          compressed={true}
          placeholder="Multi Value Delimiter, eg: ','"
          className="delimiterfield"
          name={componentNameInItemProperties}
          value={props.item.delimiter || ''}
          onChange={props.onChangeMapping}
          sanitizedfieldname={props.item.sanitizedFieldName}
        />
        <EuiSpacer size="s" />
        <EuiCheckbox
          id={'isJson_' + props.item.sanitizedFieldName}
          label="Parse as JSON array."
          checked={props.item.delimiter === 'JSON'}
          onChange={(e) => props.onChangeMapping({
            target: {
              name: componentNameInItemProperties,
              value: e.target.checked ? 'JSON' : ''
            }
          })}
        />
      </div>
    );
  }
  return (
    <div>
      <EuiSwitch
        name="multiValued"
        label="Multi-Valued?"
        checked={props.item.multiValued}
        onChange={props.onToggle}
      />
      {delimiterInput}
    </div>
  );
}

export default MultiValued;