import XLSX from 'xlsx';
import { sanitizeFieldName } from './services';

function formatUnknownHeader(unknowns) {
  return `__EMPTY${unknowns > 0 ? '_' + unknowns : ''}`;
}

function getHeaderWithType(sheet, maxRowsToParse) {
  const types = [];
  const range = XLSX.utils.decode_range(sheet['!ref']);
  let C; const R = range.s.r; /* start in the first row */
  let unknowns = 0;
  /* walk every column in the range */
  for (C = range.s.c; C <= range.e.c; ++C) {
    const type = new Object();
    let currentRow = R;
    const firstRowCell = sheet[XLSX.utils.encode_cell({ c: C, r: currentRow })]; /* find the cell in the first row */
    if (firstRowCell && firstRowCell.t) {
      type.name = XLSX.utils.format_cell(firstRowCell);
    } else {
      type.name = formatUnknownHeader(unknowns);
      unknowns++;
    }

    let cell = sheet[XLSX.utils.encode_cell({ c: C, r: ++currentRow })]; /* find the cell in the second row */
    if (!firstRowCell && !cell) {
      continue;
    }
    const rowLimit = maxRowsToParse < range.e.r ? maxRowsToParse : range.e.r;
    while (!cell && currentRow < rowLimit) {
      cell = sheet[XLSX.utils.encode_cell({ c: C, r: currentRow })];
      currentRow++;
    }
    let hdr = 'keyword'; // <-- replace with your desired default
    if (cell && cell.t) {
      switch (cell.t) {
        case 's':
          hdr = 'keyword';
          break;
        case 'n':
          hdr = 'float';
          break;
        case 'd':
          hdr = 'date';
          break;
        case 'b':
          hdr = 'boolean';
          break;
      }
    }
    type.type = hdr;
    types.push(type);
  }
  return types;
}

function getHeaderRow(sheet) {
  updateSheetRange(sheet);
  const headers = [];
  const range = XLSX.utils.decode_range(sheet['!ref']);
  let C; const R = range.s.r; /* start in the first row */
  let unknowns = 0;
  /* walk every column in the range */
  for (C = range.s.c; C <= range.e.c; ++C) {
    const cell = sheet[XLSX.utils.encode_cell({ c: C, r: R })]; /* find the cell in the first row */
    let hdr = formatUnknownHeader(unknowns); // <-- replace with your desired default
    if (cell && cell.t) {
      hdr = XLSX.utils.format_cell(cell);
    } else {
      unknowns++;
    }
    headers.push(sanitizeFieldName(hdr));
  }
  return headers;
}

function updateSheetRange(ws) {
  const range = { s: { r: 20000000, c: 20000000 }, e: { r: 0, c: 0 } };
  Object.keys(ws).filter(function (x) { return x.charAt(0) !== '!'; }).map(XLSX.utils.decode_cell).forEach(function (x) {
    range.s.c = Math.min(range.s.c, x.c); range.s.r = Math.min(range.s.r, x.r);
    range.e.c = Math.max(range.e.c, x.c); range.e.r = Math.max(range.e.r, x.r);
  });
  ws['!ref'] = XLSX.utils.encode_range(range);
}

//Replace all space in json data keys
function formatJSON(json) {
  // Iterate over array
  json.forEach(function (e, i) {
  // Iterate over the keys of object
    Object.keys(e).forEach(function (key) {
      // Copy the value
      const val = e[key];
      const newKey = sanitizeFieldName(key);
      // Remove key-value from object
      delete json[i][key];
      // Add value with new key
      json[i][newKey] = val;
    });
  });
  return json;
}

//Formats the file name to the ES index name
function setESIndexName(name) {
  if (name.lastIndexOf('.') > 0) {
    name = name.substr(0, name.lastIndexOf('.')); //removing extension
  }
  name = name.replace(/\s/g, '');               //removing space
  name = name.replace(/[^a-zA-Z0-9\-]/g, '');       //removing special characters
  name = name.toLowerCase();                    //lowercase
  return name;
}

export { getHeaderWithType, getHeaderRow, formatJSON, setESIndexName };
