import XlsxDao from '../dao/xlsx_dao';
import PapaParseDao from '../dao/pp_dao';

class SheetService {

  constructor(spreadsheetDao) {
    this.spreadsheetDao = spreadsheetDao;
  }

  static _resolveDao(file) {
    const extn = file.name.split('.').pop();
    if (extn === 'csv' || extn === 'tsv') {
      return new PapaParseDao(file);
    }
    return new XlsxDao(file);
  }

  getSheetNames() {
    return this.spreadsheetDao.getSheetNames();
  }

  sheetExists(sheetName) {
    return this.spreadsheetDao.sheetExists(sheetName);
  }

  getHeaderRow(sheetName, mapped) {
    return this.spreadsheetDao.getHeaderRow(sheetName, mapped);
  }

  /*
    Field names are unsanitized (With spaces) for better readability
   */
  getHeaderWithType(sheetName) {
    return this.spreadsheetDao.getHeaderWithType(sheetName);
  }

  /*
    Provides the JSON view of spreadsheet, might not always represent
    the entire file
   */
  sheetToJSON(sheetName, previewSize) {
    return this.spreadsheetDao.sheetToJSON(sheetName, previewSize);
  }

  /*
    indexingConfig:
      bulkSize,
      indexName,
      (optional):
        username,
        columnFilter,
        customIdModel,
        pipelineId,
        delimiters,
        mappingInfo,
   */
  ingestSheetToES(sheetName, indexingConfig, progressCallback) {
    return this.spreadsheetDao.ingestSheetToES(sheetName, indexingConfig, progressCallback);
  }

  haltIngestion() {
    this.spreadsheetDao.haltIngestion();
  }
};

export default {
  readFile: (fileArray, done, config) => {
    const spreadsheetDao = SheetService._resolveDao(fileArray[0]);
    spreadsheetDao.instantiate((error) => {
      done(new SheetService(spreadsheetDao), error);
    }, config);
  }
};