import React from 'react';
import expect from 'expect.js';
import sinon from 'sinon';
import { shallow, mount } from 'enzyme';
import {
  EuiButton,
  EuiSuperSelect,
  EuiTabbedContent
} from '@elastic/eui';

import { PipelineDefinition, DefineTransform } from '../pipeline_definition';
import { testDoc } from '../../sections/xlsx/services/__tests__/data.js';

const documents = [testDoc];
const updatePipelineDef = () => {};
const onConfigChange = () => {};
const testPipeline = () => {};

describe('ingest pipeline ', () =>  {
  describe('DefineTransform', () => {
    const configuration = {
      pipelineMethod: 'skip'
    };
    const onConfigChange = sinon.stub();
    const testPipeline = sinon.stub();
    let defineTransform;
    beforeEach(() => {
      onConfigChange.reset();
      testPipeline.reset();
      defineTransform = null;
      configuration.pipelineMethod = 'skip';
    });
    const getDefineTransform = () => {
      if (!defineTransform) {
        defineTransform = mount(
          <DefineTransform
            documents={documents}
            config={configuration}
            updatePipelineDef={updatePipelineDef}
            onConfigChange={onConfigChange}
            testPipeline={testPipeline}
          />);
      }
      return defineTransform;
    };

    it('is not rendered when pipeline is skipped', () => {
      const transform = getDefineTransform();
      expect(transform.getDOMNode().innerText).to.equal('');
    });

    it('is rendered when pipeline is NOT skipped', () => {
      configuration.pipelineMethod = 'elasticsearch';
      const transform = getDefineTransform();
      expect(transform.children().length).to.be.greaterThan(0);
      expect(transform.find(EuiTabbedContent).length).to.be.greaterThan(0);
    });

    it('testPipeline is called on click', (done) => {
      const testResponse = '{result: "pipeline"}';
      testPipeline.returns(Promise.resolve(testResponse));
      configuration.pipelineMethod = 'elasticsearch';
      const transform = getDefineTransform();
      const testButton = transform.find(EuiButton);
      expect(testButton.length).to.be.equal(1);
      testButton.simulate('click');
      expect(testPipeline.calledOnce).to.be(true);
      expect(testPipeline.getCall(0).args).to.be.eql([testDoc]);
      setTimeout(() => {
        expect(onConfigChange.calledOnce).to.be(true);
        expect(onConfigChange.getCall(0).args).to.be.eql([testResponse, 'pipelineResult']);
        done();
      }, 5);
    });
  });

  describe('pipelineMethod: skip', () => {
    const configuration = {
      pipelineMethod: 'skip'
    };
    let pipelineDOM;
    const getPipeline = () => {
      if (!pipelineDOM) {
        pipelineDOM = shallow(
          <PipelineDefinition
            documents={documents}
            configuration={configuration}
            updatePipelineDef={updatePipelineDef}
            onConfigChange={onConfigChange}
            testPipeline={testPipeline}
          />);
      }
      return pipelineDOM;
    };

    it('renders EuiSuperSelect with correct properties', () => {
      const euiSuperSelect = getPipeline().find(EuiSuperSelect);
      expect(euiSuperSelect.length).to.be.equal(1);
      expect(euiSuperSelect.props().valueOfSelected).to.be.equal(configuration.pipelineMethod);
    });

    it('DefineTransform passed correct properties', () => {
      const defineTransfrom = getPipeline().find('DefineTransform');
      expect(defineTransfrom.length).to.be.equal(1);
      expect(defineTransfrom.length).to.be.equal(1);
      expect(defineTransfrom.props().documents).to.be.equal(documents);
      expect(defineTransfrom.props().config).to.be.equal(configuration);
      expect(defineTransfrom.props().updatePipelineDef).to.be.equal(updatePipelineDef);
      expect(defineTransfrom.props().onConfigChange).to.be.equal(onConfigChange);
      expect(defineTransfrom.props().testPipeline).to.be.equal(testPipeline);
    });
  });
});
