class ConfigService {
  constructor(config) {
    this.bulkPackageSize = config.get('ingest-xlsx:bulk_package_size');
    this.previewSize = config.get('ingest-xlsx:displayed_rows');
    this.simultaneousBulkRequests = config.get('ingest-xlsx:simultaneous_bulk_requests');
    this.progressUpdationFrequency = config.get('ingest-xlsx:progress_updation_frequency');
    this.largeFile = 30000000; // Defines the criteria for a large file. Approx 30MB
    this.maxRowsToParse = 1000; // Defines max rows to parse to determine Cell Type
  }
}

let configService;
export default function getConfigService(config) {
  if (!configService) {
    if (!config) {
      throw new Error('Cannot initialize ConfigService without config object!');
    }
    configService = new ConfigService(config);
  }
  return configService;
}