import {
  EUI_MODAL_CONFIRM_BUTTON,
  EuiConfirmModal,
  EuiOverlayMask,
  EuiModal,
  EuiModalHeader,
  EuiModalHeaderTitle,
  EuiModalBody,
  EuiModalFooter,
} from '@elastic/eui';
import React from 'react';

function modalWithForm(title, form, footer, onClose) {
  return (
    <EuiOverlayMask>
      <EuiModal
        onClose={onClose}
      >
        <EuiModalHeader>
          <EuiModalHeaderTitle >
            {title}
          </EuiModalHeaderTitle>
        </EuiModalHeader>

        <EuiModalBody>
          {form}
        </EuiModalBody>

        <EuiModalFooter>
          {footer}
        </EuiModalFooter>
      </EuiModal>
    </EuiOverlayMask>
  );
}

function confirmModal(title, body, onCancel, onConfirm, cancelText, confirmText, buttonColor = 'primary') {
  return (
    <div>
      <EuiOverlayMask>
        <EuiConfirmModal
          title={title}
          onCancel={onCancel}
          onConfirm={onConfirm}
          cancelButtonText={cancelText || 'Cancel'}
          confirmButtonText={confirmText || 'Confirm'}
          buttonColor={buttonColor}
          defaultFocusedButton={EUI_MODAL_CONFIRM_BUTTON}
        >
          {body}
        </EuiConfirmModal>
      </EuiOverlayMask>
    </div>
  );
}

function confirmDestructModal(title, body, onCancel, onConfirm, destructionButtonText) {
  return confirmModal(title, body, onCancel, onConfirm, 'Cancel', destructionButtonText || 'Delete', 'danger');
}

export {
  modalWithForm,
  confirmModal,
  confirmDestructModal
};