import cloneDeep from 'lodash.clonedeep';

/*
  * Converts a JSON Object to a prettified string
  * The object is returned as-is if its not JSON or null/undefined
 */
function  jsonObjectToString(advJson) {
  if (advJson && typeof advJson === 'object') {
    return JSON.stringify(advJson, null, 2);
  }
  return advJson;
}

/*
  * Tries to parse a JSON String to an object
  * The value is returned as-is if its not a String, null/undefined
  * If the parsing fails, undefined is returned
 */
function jsonStringToObject(json) {
  if (json && typeof json === 'string') {
    try {
      json = JSON.parse(json);
    } catch (e) {
      json = undefined;
    }
  } else if (typeof json === 'object') {
    json = cloneDeep(json);
  }
  return json;
}
export {
  jsonObjectToString,
  jsonStringToObject
};