export default function (server, dataCluster, CONFIG_INDEX, xlsxApiPath) {

  // GET list of configs with Fields
  server.route({
    path: `${xlsxApiPath}list/configs`,
    method: 'GET',
    handler(req, reply) {
      dataCluster.callWithRequest(req, 'search', {
        index: CONFIG_INDEX,
        type: 'doc',
        body: {
          size: 200,
          _source: [
            'name',
            'description'
          ]
        }
      }).then(reply).catch((e) => {
        if (e.status === 404) {
          reply({
            hits: {
              total: 0
            }
          });
        } else {
          reply(e);
        }
      });
    }
  });

  // GET config
  server.route({
    path: `${xlsxApiPath}configs/{configId}`,
    method: 'GET',
    handler(req, reply) {
      dataCluster.callWithRequest(req, 'get', {
        index: CONFIG_INDEX,
        type: 'doc',
        id: req.params.configId
      })
        .then(function (response) {
          reply(response);
        }).catch((e) => reply(e));
    }
  });

  // DELETE config
  server.route({
    path: `${xlsxApiPath}configs/{configId}`,
    method: 'DELETE',
    handler(req, reply) {
      dataCluster.callWithRequest(req, 'delete', {
        index: CONFIG_INDEX,
        type: 'doc',
        id: req.params.configId
      })
        .then(function (response) {
          reply(response);
        }).catch((e) => reply(e));
    }
  });

  // PUT config
  server.route({
    path: `${xlsxApiPath}config`,
    method: 'POST',
    handler(req, reply) {
      dataCluster.callWithRequest(req, 'index', {
        index: CONFIG_INDEX,
        type: 'doc',
        body: req.payload
      })
        .then(function (response) {
          reply(response);
        }).catch((e) => reply(e));
    }
  });

  // PUT config with ID
  server.route({
    path: `${xlsxApiPath}configs/{configId}`,
    method: 'POST',
    handler(req, reply) {
      dataCluster.callWithRequest(req, 'index', {
        index: CONFIG_INDEX,
        type: 'doc',
        id: req.params.configId,
        body: req.payload
      })
        .then(function (response) {
          reply(response);
        }).catch((e) => reply(e));
    }
  });

  // GET cluster health
  server.route({
    path: `${xlsxApiPath}health`,
    method: 'GET',
    handler(req, reply) {
      dataCluster.callWithRequest(req, 'cluster.health')
      	.then(function (response) {
      		reply(response);
  		});
  	}
  });

  // Perform single POST for creating / adding document to an index
  server.route({
    path: `${xlsxApiPath}index/{index}/{type}`,
    method: 'POST',
    handler(req, reply) {
      dataCluster.callWithRequest(req, 'index', {
        index: req.params.index,
        type: req.params.type,
        body: req.payload
      })
        .then(function (err, response) {
          if (err) {
            reply(err);
          }
          else {
            reply(response);
          }
        });
    }
  });

  // PUT a pipeline definition
  server.route({
    path: `${xlsxApiPath}pipeline/{pipelineid}`,
    method: 'POST',
    handler(req, reply) {
      dataCluster.callWithRequest(req, 'transport.request', {
        path: `_ingest/pipeline/${req.params.pipelineid}`,
        method: 'PUT',
        body: req.payload
      })
        .then(function (err, response) {
          if (err) {
            reply(err);
          }
          else {
            reply(response);
          }
        }).catch(e => reply(e));
    }
  });

  // DELETE a pipeline definition
  server.route({
    path: `${xlsxApiPath}delete-pipeline/{pipelineid}`,
    method: 'DELETE',
    handler(req, reply) {
      dataCluster.callWithRequest(req, 'transport.request', {
        path: `_ingest/pipeline/${req.params.pipelineid}`,
        method: 'DELETE'
      })
        .then(function (err, response) {
          if (err) {
            reply(err);
          }
          else {
            reply(response);
          }
        });
    }
  });

  // Perform BULK for creating / adding multiple documents to an index
  server.route({
    path: `${xlsxApiPath}{index}/{type}/_bulk/{pipelineid?}`,
    method: 'POST',
    handler(req, reply) {
    	dataCluster.callWithRequest(req, 'bulk', {
        index: req.params.index,
        type: req.params.type,
    		body: req.payload,
        ...req.params.pipelineid && { pipeline: req.params.pipelineid }
    	})
        .then((response) => {
          reply(response);

        }).catch((e) => {
          reply({ 'error': e });
        });
    	}
  });

  // Create a mapping for a selected index and type
  server.route({
    path: `${xlsxApiPath}{index}/_mapping/{type}`,
    method: 'POST',
    handler(req, reply) {
      dataCluster.callWithRequest(req, 'indices.putMapping', {
        index: req.params.index,
        type: req.params.type,
        body: req.payload,
      })
        .then((response) => {
          reply(response);

        }).catch((e) => {
          reply({ 'error': e });
        });
    }
  });

  // creating index
  server.route({
    path: `${xlsxApiPath}{index}`,
    method: 'POST',
    handler(req, reply) {
      dataCluster.callWithRequest(req, 'indices.create', {
        index: req.params.index,
        body: req.payload
      })
        .then((response) => {
          reply(response);

        }).catch((e) => {
          reply({ 'error': e });
        });
    }
  });

  // checking index
  server.route({
    path: `${xlsxApiPath}{index}/_exists`,
    method: 'GET',
    handler(req, reply) {
      dataCluster.callWithRequest(req, 'indices.get', {
        index: req.params.index,
        body: req.payload,
        ignore: [404, 403]
      })
        .then(function (err, response) {
          if (err)
          {reply(err);}
          else
          {reply(response);}
        });
    }
  });

  // deleting index
  server.route({
    path: `${xlsxApiPath}{index}`,
    method: 'DELETE',
    handler(req, reply) {
      dataCluster.callWithRequest(req, 'indices.delete', {
        index: req.params.index,
        body: req.payload
      })
        .then((response) => {
          reply(response);

        }).catch((e) => {
          reply({ 'error': e });
        });
    }
  });
}
