import ngMock from 'ng_mock';
import expect from 'expect.js';
import { VisProvider } from 'ui/vis';
import { stubbedLogstashIndexPatternService } from 'fixtures/stubbed_logstash_index_pattern';
import { VisTypesRegistryProvider } from 'ui/registry/vis_types';

describe('initialization', function () {
  let Vis;
  let vis;
  let visTypes;
  let indexPattern;
  let stateFixture = {
    type: 'multi_chart_vis'
  };

  beforeEach(ngMock.module('kibana'));

  beforeEach(ngMock.inject(function (Private) {
    Vis = Private(VisProvider);
    indexPattern = Private(stubbedLogstashIndexPatternService);
    visTypes = Private(VisTypesRegistryProvider);
  }));

  beforeEach(function () {
    vis = new Vis(indexPattern, stateFixture);
  });

  it('should set the state', function () {
    expect(vis).to.have.property('type');
    expect(vis.type).to.eql(visTypes.byName.multi_chart_vis);

    expect(vis).to.have.property('params');

    expect(vis).to.have.property('indexPattern', indexPattern);
  });

});
