import ngMock from 'ng_mock';
import expect from 'expect.js';
import sinon from 'sinon';
import Promise from 'bluebird';

describe('smart default configuration', function () {
  let fieldStatsAnalysis;
  const ip = {};

  beforeEach(ngMock.module('kibana'));
  beforeEach(ngMock.module('kibana/multi_chart_vis'));
  beforeEach(ngMock.inject(function ($injector) {
    fieldStatsAnalysis = $injector.get('multiChartSDC');
  }));

  describe('boolean field type', function () {
    it('case1 - basic', function (done) {
      const field = {
        name: 'dummy',
        displayName: 'dummyDisplay',
        type: 'boolean',
        aggregatable: true
      };

      fieldStatsAnalysis(ip, field).then(resp => {
        expect(resp).to.have.property('vis', 'pie');
        expect(resp).to.have.property('field', 'dummyDisplay');
        expect(resp).to.have.property('aggs');
        expect(resp.aggs.length).to.be(2);
        expect(resp.aggs[0]).to.have.property('type', 'count');
        expect(resp.aggs[0]).to.have.property('schema', 'metric');
        expect(resp.aggs[1]).to.have.property('type', 'terms');
        expect(resp.aggs[1]).to.have.property('schema', 'segment');
        expect(resp.aggs[1]).to.have.property('params');
        expect(resp.aggs[1].params).to.have.property('field', 'dummy');
        expect(resp.aggs[1].params).to.have.property('size', 2);
        done();
      }).catch(done);
    });

  });
});
