import ngMock from 'ng_mock';
import expect from 'expect.js';
import compareFields from 'plugins/multi_chart_vis/sdc/sdc_compare';

let testActualArray = {
  testField_1: {
    name: 'testField_1',
    visualizable: true
  },
  testField_2: {
    name: 'testField_2',
    visualizable: true
  },
  testField_3: {
    name: 'testField_3',
    visualizable: true
  },
  testField_4: {
    name: 'testField_4',
    visualizable: true
  },
  testField_5: {
    name: 'testField_5',
    visualizable: true
  }
};
let testStateArray = [
  {
    aggs: [
      null,
      {
        params: {
          field: 'testField_toDelete_1'
        }
      }
    ]
  },
  {
    aggs: [
      null,
      {
        params: {
          field: 'testField_1'
        }
      }
    ]
  },
  {
    aggs: [
      null,
      {
        params: {
          field: 'testField_2'
        }
      }
    ]
  },
  {
    aggs: [
      null,
      {
        params: {
          field: 'testField_toDelete_2'
        }
      }
    ]
  },
  {
    aggs: [
      null,
      {
        params: {
          field: 'testField_3'
        }
      }
    ]
  },
  {
    aggs: [
      null,
      {
        params: {
          field: 'testField_4'
        }
      }
    ]
  },
  {
    aggs: [
      null,
      {
        params: {
          field: 'testField_toDelete_3'
        }
      }
    ]
  }
];
let testVisState = {
  indexPattern: {
    metaFields: [
      '_source',
      '_id',
      '_type',
      '_index',
      '_score'
    ],
    fields: {
      byName: testActualArray
    }
  },
  _editableVis: {
    visStateManager: {
      state: {
        settings: testStateArray
      }
    }
  }
};

describe('compare fields', function () {

  describe('correct checking in fields', () => {
    it('data was marked correctly for deleting', () => {
      expect(compareFields(testVisState).indexesToDelete.join('')).to.equal('630');
    });

    it('data was marked correctly for adding', () => {
      expect(compareFields(testVisState).fieldsToAdd[0].name).to.equal('testField_5');
    });

    it('counters return correct value', () => {
      expect(compareFields(testVisState).addedCount).to.equal(1);
      expect(compareFields(testVisState).removedCount).to.equal(3);
    });
  });
});