import ngMock from 'ng_mock';
import expect from 'expect.js';
import sinon from 'sinon';
import Promise from 'bluebird';

describe('smart default configuration', function () {
  let fieldStatsAnalysis;
  const ip = {};

  beforeEach(ngMock.module('kibana'));
  beforeEach(ngMock.module('kibana/multi_chart_vis'));
  beforeEach(ngMock.inject(function ($injector) {
    fieldStatsAnalysis = $injector.get('multiChartSDC');
  }));

  describe('date field type', function () {
    it('case1 - basic', function (done) {
      const field = {
        name: 'dummy',
        displayName: 'dummyDisplay',
        type: 'date',
        aggregatable: true
      };

      fieldStatsAnalysis(ip, field).then(resp => {
        expect(resp).to.have.property('vis', 'line');
        expect(resp).to.have.property('field', 'dummyDisplay');
        expect(resp).to.have.property('aggs');
        expect(resp.aggs.length).to.be(2);
        expect(resp.aggs[0]).to.have.property('type', 'count');
        expect(resp.aggs[0]).to.have.property('schema', 'metric');
        expect(resp.aggs[1]).to.have.property('type', 'date_histogram');
        expect(resp.aggs[1]).to.have.property('schema', 'segment');
        expect(resp.aggs[1]).to.have.property('params');
        expect(resp.aggs[1].params).to.have.property('field', 'dummy');
        expect(resp.aggs[1].params).to.have.property('interval', 'M');
        expect(resp.aggs[1].params).to.have.property('min_doc_count', 1);
        expect(resp.aggs[1].params).to.have.property('customInterval', '2h');
        expect(resp.aggs[1].params).to.have.property('extended_bounds');
        done();
      }).catch(done);
    });

  });
});
