import expect from 'expect.js';
import logicNames from 'plugins/multi_chart_vis/sdc/sdc_names';

let testConfigState = {
  activeSetting: {
    name: 'name 1'
  },
  state: {
    settings: [
      { name: 'name 1' },
      { name: 'name 2' },
      { name: 'name 3' },
      { name: 'name 3 (copy)' },
      { name: 'name 4' },
      { name: 'name 4 (copy)' },
      { name: 'name 4 (copy #1)' },
      { name: 'name 5' },
      { name: 'name 5 (copy)' },
      { name: 'name 5 (copy #1)' },
      { name: 'name 5 (copy #2)' },
      { name: 'name 5 (copy #5)' },
      { name: 'name 5 (copy #6)' },
      { name: 'name 6' },
      { name: 'name 6 (copy)' },
      { name: 'name 6 (copy #2)' },
      { name: 'name 7' },
      { name: 'name 7 (copy #2)' },
      { name: 'name 8 (copy #XX)' },
      { name: 'name 9 (copy #0)' },
      { name: 'name 10 (copy #-1)' }
    ]
  }
};

describe('work with names', function () {

  describe('generateCopyName()', () => {
    it('should return correct generated new names', () => {
      expect(logicNames.generateCopyName(testConfigState)).to.equal('name 1 (copy)');
      testConfigState.activeSetting.name = 'name 3';
      expect(logicNames.generateCopyName(testConfigState)).to.equal('name 3 (copy #1)');
      testConfigState.activeSetting.name = 'name 3 (copy)';
      expect(logicNames.generateCopyName(testConfigState)).to.equal('name 3 (copy #1)');
      testConfigState.activeSetting.name = 'name 4';
      expect(logicNames.generateCopyName(testConfigState)).to.equal('name 4 (copy #2)');
      testConfigState.activeSetting.name = 'name 4 (copy)';
      expect(logicNames.generateCopyName(testConfigState)).to.equal('name 4 (copy #2)');
      testConfigState.activeSetting.name = 'name 4 (copy #1)';
      expect(logicNames.generateCopyName(testConfigState)).to.equal('name 4 (copy #2)');
      testConfigState.activeSetting.name = 'name 5';
      expect(logicNames.generateCopyName(testConfigState)).to.equal('name 5 (copy #3)');
      testConfigState.activeSetting.name = 'name 6';
      expect(logicNames.generateCopyName(testConfigState)).to.equal('name 6 (copy #1)');
      testConfigState.activeSetting.name = 'name 7';
      expect(logicNames.generateCopyName(testConfigState)).to.equal('name 7 (copy)');
      testConfigState.activeSetting.name = 'name 8 (copy #XX)';
      expect(logicNames.generateCopyName(testConfigState)).to.equal('name 8 (copy #XX) (copy)');
      testConfigState.activeSetting.name = 'name 9 (copy #0)';
      expect(logicNames.generateCopyName(testConfigState)).to.equal('name 9 (copy #0) (copy)');
      testConfigState.activeSetting.name = 'name 10 (copy #-1)';
      expect(logicNames.generateCopyName(testConfigState)).to.equal('name 10 (copy #-1) (copy)');
    })
  });

  describe('namesConflict()', () => {
    it('should return true if name already exists in the list', () => {
      expect(logicNames.namesConflict('name 1', testConfigState)).to.equal(true);
    })
    it('should return false if name does not exist in the list', () => {
      expect(logicNames.namesConflict('name', testConfigState)).to.equal(false);
    })
  });
})