import ngMock from 'ng_mock';
import expect from 'expect.js';
import sinon from 'sinon';
import Promise from 'bluebird';
import case1 from './fixtures/number/case1';
import case2 from './fixtures/number/case2';
import case3 from './fixtures/number/case3';
import case4 from './fixtures/number/case4';

describe('smart default configuration', function () {
  let fieldStatsAnalysis;
  let sdcQuery;
  const ip = {};

  beforeEach(ngMock.module('kibana'));
  beforeEach(ngMock.module('kibana/multi_chart_vis'));
  beforeEach(ngMock.inject(function ($injector) {
    fieldStatsAnalysis = $injector.get('multiChartSDC');
    sdcQuery = $injector.get('multiChartSDCQuery');
  }));

  describe('number field type', function () {
    it('case1 - fewer unique values - data has outliers', function (done) {
      const field = {
        name: 'founded_year',
        displayName: 'founded_year',
        type: 'number',
        aggregatable: true
      };
      sinon.stub(sdcQuery, 'searchAgg').callsFake((index, aggs) => {
        if (aggs['1']) {
          if (aggs['1'].cardinality) {
            expect(aggs['1'].cardinality).to.have.property('field');
            return Promise.resolve(case1.a());
          } else {
            expect(aggs['1']).to.have.property('min');
            return Promise.resolve(case1.c());
          }
        } else {
          expect(aggs).to.have.property('2');
          if (aggs['2'].histogram) {
            expect(aggs['2'].histogram).to.have.property('field');
            return Promise.resolve(case1.e());
          } else {
            expect(aggs['2']).to.have.property('terms');
            expect(aggs['2'].terms).to.have.property('field');
            return Promise.resolve(case1.b());
          }
        }
      });
      sinon.stub(sdcQuery, 'searchRandom').returns(Promise.resolve(case1.d()));

      fieldStatsAnalysis(ip, field).then(resp => {
        expect(resp).to.have.property('vis', 'histogram');
        expect(resp).to.have.property('field', 'founded_year');
        expect(resp).to.have.property('aggs');
        expect(resp.aggs.length).to.be(2);
        expect(resp.aggs[0]).to.have.property('type', 'count');
        expect(resp.aggs[0]).to.have.property('schema', 'metric');
        expect(resp.aggs[1]).to.have.property('type', 'histogram');
        expect(resp.aggs[1]).to.have.property('schema', 'segment');
        expect(resp.aggs[1]).to.have.property('params');
        expect(resp.aggs[1].params).to.have.property('field', 'founded_year');
        expect(resp.aggs[1].params).to.have.property('interval');
        done();
      }).catch(done);
    });

    it('case2 - fewer unique values - data has outliers II', function (done) {
      const field = {
        name: 'number_of_employees',
        displayName: 'number_of_employees',
        type: 'number',
        aggregatable: true
      };
      sinon.stub(sdcQuery, 'searchAgg').callsFake((index, aggs) => {
        if (aggs['1']) {
          if (aggs['1'].cardinality) {
            expect(aggs['1'].cardinality).to.have.property('field');
            return Promise.resolve(case2.a());
          } else {
            expect(aggs['1']).to.have.property('min');
            return Promise.resolve(case2.c());
          }
        } else {
          expect(aggs).to.have.property('2');
          if (aggs['2'].histogram) {
            expect(aggs['2'].histogram).to.have.property('field');
            return Promise.resolve(case2.e());
          } else {
            expect(aggs['2']).to.have.property('terms');
            expect(aggs['2'].terms).to.have.property('field');
            return Promise.resolve(case2.b());
          }
        }
      });
      sinon.stub(sdcQuery, 'searchRandom').returns(Promise.resolve(case2.d()));

      fieldStatsAnalysis(ip, field).then(resp => {
        expect(resp).to.have.property('vis', 'histogram');
        expect(resp).to.have.property('field', 'number_of_employees');
        expect(resp).to.have.property('aggs');
        expect(resp.aggs.length).to.be(2);
        expect(resp.aggs[0]).to.have.property('type', 'count');
        expect(resp.aggs[0]).to.have.property('schema', 'metric');
        expect(resp.aggs[1]).to.have.property('type', 'histogram');
        expect(resp.aggs[1]).to.have.property('schema', 'segment');
        expect(resp.aggs[1]).to.have.property('params');
        expect(resp.aggs[1].params).to.have.property('field', 'number_of_employees');
        expect(resp.aggs[1].params).to.have.property('interval');
        done();
      }).catch(done);
    });

    it('case3 - fewer unique values - less than 100', function (done) {
      const field = {
        name: 'founded_month',
        displayName: 'founded_month',
        type: 'number',
        aggregatable: true
      };
      sinon.stub(sdcQuery, 'searchAgg').callsFake((index, aggs) => {
        if (aggs['1']) {
          expect(aggs['1']).to.have.property('cardinality');
          expect(aggs['1'].cardinality).to.have.property('field');
          return Promise.resolve(case3.a());
        }
      });

      fieldStatsAnalysis(ip, field).then(resp => {
        expect(resp).to.have.property('vis', 'histogram');
        expect(resp).to.have.property('field', 'founded_month');
        expect(resp).to.have.property('aggs');
        expect(resp.aggs.length).to.be(2);
        expect(resp.aggs[0]).to.have.property('type', 'count');
        expect(resp.aggs[0]).to.have.property('schema', 'metric');
        expect(resp.aggs[1]).to.have.property('type', 'histogram');
        expect(resp.aggs[1]).to.have.property('schema', 'segment');
        expect(resp.aggs[1]).to.have.property('params');
        expect(resp.aggs[1].params).to.have.property('field', 'founded_month');
        expect(resp.aggs[1].params).to.have.property('interval', 1);
        done();
      }).catch(done);
    });

    it('case4 - mostly unique values - no outliers', function (done) {
      const field = {
        name: 'raised_amount',
        displayName: 'raised_amount',
        type: 'number',
        aggregatable: true
      };
      sinon.stub(sdcQuery, 'searchAgg').callsFake((index, aggs) => {
        if (aggs['1']) {
          if (aggs['1'].cardinality) {
            expect(aggs['1'].cardinality).to.have.property('field');
            return Promise.resolve(case4.a());
          } else {
            expect(aggs['1']).to.have.property('min');
            return Promise.resolve(case4.c());
          }
        } else {
          expect(aggs).to.have.property('2');
          if (aggs['2'].histogram) {
            expect(aggs['2'].histogram).to.have.property('field');
            return Promise.resolve(case4.e());
          } else {
            expect(aggs['2']).to.have.property('terms');
            expect(aggs['2'].terms).to.have.property('field');
            return Promise.resolve(case4.b());
          }
        }
      });
      sinon.stub(sdcQuery, 'searchRandom').returns(Promise.resolve(case4.d()));

      fieldStatsAnalysis(ip, field).then(resp => {
        expect(resp).to.have.property('vis', 'histogram');
        expect(resp).to.have.property('field', 'raised_amount');
        expect(resp).to.have.property('aggs');
        expect(resp.aggs.length).to.be(2);
        expect(resp.aggs[0]).to.have.property('type', 'count');
        expect(resp.aggs[0]).to.have.property('schema', 'metric');
        expect(resp.aggs[1]).to.have.property('type', 'range');
        expect(resp.aggs[1]).to.have.property('schema', 'segment');
        expect(resp.aggs[1]).to.have.property('params');
        expect(resp.aggs[1].params).to.have.property('field', 'raised_amount');
        expect(resp.aggs[1].params).to.have.property('ranges');
        expect(resp.aggs[1].params.ranges.length).to.be(5);
        expect(resp.aggs[1].params.ranges[0]).to.have.property('from');
        expect(resp.aggs[1].params.ranges[0]).to.have.property('to');
        done();
      }).catch(done);
    });


  });
});
