import ngMock from 'ng_mock';
import expect from 'expect.js';
import sinon from 'sinon';
import Promise from 'bluebird';
import case1 from './fixtures/string/case1';
import case2 from './fixtures/string/case2';
import case3 from './fixtures/string/case3';
import case4 from './fixtures/string/case4';
import case5 from './fixtures/string/case5';
import case6 from './fixtures/string/case6';

describe('smart default configuration', function () {
  let fieldStatsAnalysis;
  let sdcQuery;
  const ip = {};

  beforeEach(ngMock.module('kibana'));
  beforeEach(ngMock.module('kibana/multi_chart_vis'));
  beforeEach(ngMock.inject(function ($injector) {
    fieldStatsAnalysis = $injector.get('multiChartSDC');
    sdcQuery = $injector.get('multiChartSDCQuery');
  }));

  describe('string field type', function () {
    it('case1 - mostly unique values - no outliers I', function (done) {
      const field = {
        name: 'city',
        displayName: 'city',
        type: 'string',
        aggregatable: true
      };
      sinon.stub(sdcQuery, 'searchAgg').callsFake((index, aggs) => {
        if (aggs['1']) {
          expect(aggs['1']).to.have.property('cardinality');
          expect(aggs['1'].cardinality).to.have.property('field');
          return Promise.resolve(case1.a());
        } else {
          expect(aggs).to.have.property('2');
          expect(aggs['2']).to.have.property('terms');
          expect(aggs['2'].terms).to.have.property('field');
          return Promise.resolve(case1.b());
        }
      });

      fieldStatsAnalysis(ip, field).then(resp => {
        expect(resp).to.have.property('vis', 'histogram');
        expect(resp).to.have.property('field', 'city');
        expect(resp).to.have.property('aggs');
        expect(resp.aggs.length).to.be(2);
        expect(resp.aggs[0]).to.have.property('type', 'count');
        expect(resp.aggs[0]).to.have.property('schema', 'metric');
        expect(resp.aggs[1]).to.have.property('type', 'terms');
        expect(resp.aggs[1]).to.have.property('schema', 'segment');
        expect(resp.aggs[1]).to.have.property('params');
        expect(resp.aggs[1].params).to.have.property('field', 'city');
        expect(resp.aggs[1].params).to.have.property('size');
        done();
      }).catch(done);
    });

    it('case2 - mostly unique values - no outliers II', function (done) {
      const field = {
        name: 'one_competitor',
        displayName: 'one_competitor',
        type: 'string',
        aggregatable: true
      };
      sinon.stub(sdcQuery, 'searchAgg').callsFake((index, aggs) => {
        if (aggs['1']) {
          expect(aggs['1']).to.have.property('cardinality');
          expect(aggs['1'].cardinality).to.have.property('field');
          return Promise.resolve(case2.a());
        } else {
          expect(aggs).to.have.property('2');
          expect(aggs['2']).to.have.property('terms');
          expect(aggs['2'].terms).to.have.property('field');
          return Promise.resolve(case2.b());
        }
      });

      fieldStatsAnalysis(ip, field).then(resp => {
        expect(resp).to.have.property('vis', 'histogram');
        expect(resp).to.have.property('field', 'one_competitor');
        expect(resp).to.have.property('aggs');
        expect(resp.aggs.length).to.be(2);
        expect(resp.aggs[0]).to.have.property('type', 'count');
        expect(resp.aggs[0]).to.have.property('schema', 'metric');
        expect(resp.aggs[1]).to.have.property('type', 'terms');
        expect(resp.aggs[1]).to.have.property('schema', 'segment');
        expect(resp.aggs[1]).to.have.property('params');
        expect(resp.aggs[1].params).to.have.property('field', 'one_competitor');
        expect(resp.aggs[1].params).to.have.property('size');
        done();
      }).catch(done);
    });

    it('case3 - fewer unique values - data has fewer outliers', function (done) {
      const field = {
        name: 'countrycode',
        displayName: 'countrycode',
        type: 'string',
        aggregatable: true
      };
      sinon.stub(sdcQuery, 'searchAgg').callsFake((index, aggs) => {
        if (aggs['1']) {
          expect(aggs['1']).to.have.property('cardinality');
          expect(aggs['1'].cardinality).to.have.property('field');
          return Promise.resolve(case3.a());
        } else {
          expect(aggs).to.have.property('2');
          expect(aggs['2']).to.have.property('terms');
          expect(aggs['2'].terms).to.have.property('field');
          return Promise.resolve(case3.b());
        }
      });

      fieldStatsAnalysis(ip, field).then(resp => {
        expect(resp).to.have.property('vis', 'table');
        expect(resp).to.have.property('field', 'countrycode');
        expect(resp).to.have.property('aggs');
        expect(resp.aggs.length).to.be(2);
        expect(resp.aggs[0]).to.have.property('type', 'count');
        expect(resp.aggs[0]).to.have.property('schema', 'metric');
        expect(resp.aggs[1]).to.have.property('type', 'terms');
        expect(resp.aggs[1]).to.have.property('schema', 'segment');
        expect(resp.aggs[1]).to.have.property('params');
        expect(resp.aggs[1].params).to.have.property('field', 'countrycode');
        expect(resp.aggs[1].params).to.have.property('size');
        done();
      }).catch(done);
    });

    it('case4 - mostly unique values - no outliers - aggregatable field', function (done) {
      const field = {
        name: 'description',
        displayName: 'description',
        type: 'text',
        aggregatable: true
      };
      sinon.stub(sdcQuery, 'searchAgg').callsFake((index, aggs) => {
        if (aggs['1']) {
          expect(aggs['1']).to.have.property('cardinality');
          expect(aggs['1'].cardinality).to.have.property('field');
          return Promise.resolve(case4.a());
        } else {
          expect(aggs).to.have.property('2');
          expect(aggs['2']).to.have.property('terms');
          expect(aggs['2'].terms).to.have.property('field');
          return Promise.resolve(case4.b());
        }
      });

      fieldStatsAnalysis(ip, field).then(resp => {
        expect(resp).to.have.property('vis', 'tagcloud');
        expect(resp).to.have.property('field', 'description');
        expect(resp).to.have.property('aggs');
        expect(resp.aggs.length).to.be(2);
        expect(resp.aggs[0]).to.have.property('type', 'count');
        expect(resp.aggs[0]).to.have.property('schema', 'metric');
        expect(resp.aggs[1]).to.have.property('type', 'terms');
        expect(resp.aggs[1]).to.have.property('schema', 'segment');
        expect(resp.aggs[1]).to.have.property('params');
        expect(resp.aggs[1].params).to.have.property('field', 'description');
        expect(resp.aggs[1].params).to.have.property('size');
        done();
      }).catch(done);
    });

    it('case5 - mostly unique values - no outliers - data could be mostly IDs', function (done) {
      const field = {
        name: 'id',
        displayName: 'id',
        type: 'string',
        aggregatable: true
      };
      sinon.stub(sdcQuery, 'searchAgg').callsFake((index, aggs) => {
        if (aggs['1']) {
          expect(aggs['1']).to.have.property('cardinality');
          expect(aggs['1'].cardinality).to.have.property('field');
          return Promise.resolve(case5.a());
        } else {
          expect(aggs).to.have.property('2');
          expect(aggs['2']).to.have.property('terms');
          expect(aggs['2'].terms).to.have.property('field');
          return Promise.resolve(case5.b());
        }
      });

      fieldStatsAnalysis(ip, field).then(resp => {
        expect(resp).to.have.property('vis', 'table');
        expect(resp).to.have.property('field', 'id');
        expect(resp).to.have.property('aggs');
        expect(resp.aggs.length).to.be(2);
        expect(resp.aggs[0]).to.have.property('type', 'count');
        expect(resp.aggs[0]).to.have.property('schema', 'metric');
        expect(resp.aggs[1]).to.have.property('type', 'terms');
        expect(resp.aggs[1]).to.have.property('schema', 'segment');
        expect(resp.aggs[1]).to.have.property('params');
        expect(resp.aggs[1].params).to.have.property('field', 'id');
        expect(resp.aggs[1].params).to.have.property('size');
        done();
      }).catch(done);
    });

    it('case6 - less than 10 unique values - data has outliers', function (done) {
      const field = {
        name: 'revenuedate',
        displayName: 'revenuedate',
        type: 'string',
        aggregatable: true
      };
      sinon.stub(sdcQuery, 'searchAgg').callsFake((index, aggs) => {
        if (aggs['1']) {
          expect(aggs['1']).to.have.property('cardinality');
          expect(aggs['1'].cardinality).to.have.property('field');
          return Promise.resolve(case6.a());
        } else {
          expect(aggs).to.have.property('2');
          expect(aggs['2']).to.have.property('terms');
          expect(aggs['2'].terms).to.have.property('field');
          return Promise.resolve(case6.b());
        }
      });

      fieldStatsAnalysis(ip, field).then(resp => {
        expect(resp).to.have.property('vis', 'table');
        expect(resp).to.have.property('field', 'revenuedate');
        expect(resp).to.have.property('aggs');
        expect(resp.aggs.length).to.be(2);
        expect(resp.aggs[0]).to.have.property('type', 'count');
        expect(resp.aggs[0]).to.have.property('schema', 'metric');
        expect(resp.aggs[1]).to.have.property('type', 'terms');
        expect(resp.aggs[1]).to.have.property('schema', 'segment');
        expect(resp.aggs[1]).to.have.property('params');
        expect(resp.aggs[1].params).to.have.property('field', 'revenuedate');
        expect(resp.aggs[1].params).to.have.property('size');
        done();
      }).catch(done);
    });



  });
});
