import _ from 'lodash';
import template from './multi_chart_vis_options.html';
import './multi_chart_vis_options.less';
import { uiModules } from 'ui/modules';
const module = uiModules.get('kibana/multi_chart_vis');

module.directive('multiChartVisOptions', function () {
  return {
    restrict: 'E',
    template: template,
    scope: {
      settings: '=',
      typeSelector: '=',
      configSelector: '=',
      circleButtons: '=',
      vis: '=',
      updated: '&'
    },
    link: function ($scope, $element, $attrs) {
      function getOptions() {
        let options = $scope.vis.getUiState().get('options');
        if (_.size(options) === 0) {
          options = {
            configSelector: true,
            typeSelector: true,
            circleButtons: true
          };
        }
        return options;
      }

      $scope.saveOption = function (name) {
        const options = getOptions();
        options[name] = $scope[name];
        $scope.vis.getUiState().set('options', options);
        $scope.updated();
      };

      const options = getOptions();
      $scope.configSelector = options.configSelector;
      $scope.typeSelector = options.typeSelector;
      $scope.circleButtons = options.circleButtons;

      $scope.$watch('configSelector', function () {
        $scope.saveOption('configSelector');
      });

      $scope.$watch('typeSelector', function () {
        $scope.saveOption('typeSelector');
      });

      $scope.$watch('circleButtons', function () {
        $scope.saveOption('circleButtons');
      });
    }
  };
});
