export default class InnerPlugin {
  constructor(type, title, icon, visible = true) {
    this._type = type;
    this._title = title;
    this._icon = icon;
    this._visible = visible;
  }

  get type() {
    return this._type;
  }

  get title() {
    return this._title;
  }

  get icon() {
    return this._icon;
  }

  get visible() {
    return this._visible;
  }

  get isTemplateVis() {
    return false;
  }

  _prebuildAggDefinitionStrategy(anAgg) {
    if (anAgg.schema === 'radius') {
      return false;
    }
    return true;
  }

  _buildAggDefinitionStrategy(anAgg, schemaState) {
    if (anAgg.schema === 'group') {
      if (++schemaState.groupCount > 1) {
        schemaState.groupMaxReached = true;
        return false;
      }
    }
    return true;
  }

  buildAggDefinition(anAgg, schemaState) {
    if (!this._prebuildAggDefinitionStrategy(anAgg)) {
      return false;
    }
    return this._buildAggDefinitionStrategy(anAgg, schemaState);
  }

  updateSchemaDefinition(name, schemaState) {
    return this._updateSchemaDefinitionStrategy(name, schemaState);
  }

  _updateSchemaDefinitionStrategy(name, schemaState) {
    if (name === 'segment' && schemaState.segmentMaxReached) {
      name = '';
    }
    if (name === 'group' && schemaState.groupMaxReached) {
      name = '';
    }
    return name;
  }

  disableDuplicatedSchemas(schema, aggs) {
    this._disableDuplicatedSchemasStrategy(schema, aggs);
  }

  _disableDuplicatedSchemasStrategy(schema, aggs) {
    if (schema.name === 'group' && aggs[schema.name] && aggs[schema.name].length > 0) {
      schema.disabled = true;
    }
  }
}
