import InnerPlugin from './base';

export default class BubbleDiagramInnerPlugin extends InnerPlugin {
  constructor(type, title, icon) {
    super('bubble_diagram_vis', 'Bubble', 'fa-bullseye');
  }

  get isTemplateVis() {
    return true;
  }

  _buildAggDefinitionStrategy(anAgg, schemaState) {
    if (anAgg.schema === 'group' || anAgg.schema === 'segment' || anAgg.schema === 'split') {
      anAgg.schema = 'segment';
      if (++schemaState.segmentCount > 2) {
        schemaState.segmentMaxReached = true;
        return false;
      }
    }
    return true;
  }

  _updateSchemaDefinitionStrategy(name, schemaState) {
    if (name === 'group') {
      name = 'segment';
    }
    if (schemaState.segmentCount === 2 || schemaState.segmentMaxReached) {
      name = '';
    }
  }

  _disableDuplicatedSchemasStrategy(schema, aggs) {
    if (schema.name === 'group' && !aggs.segment) {
      schema.disabled = true;
    }
  }
}
