import InnerPlugin from './base';

export default class TableInnerPlugin extends InnerPlugin {
  constructor(type, title, icon) {
    super('table', 'Table', 'fa-table');
  }

  _buildAggDefinitionStrategy(anAgg) {
    if (anAgg.schema === 'group' || anAgg.schema === 'segment') {
      anAgg.schema = 'bucket';
    }
    return true;
  }

  _updateSchemaDefinitionStrategy(name) {
    if (name === 'group' || name === 'segment') {
      name = 'bucket';
    }
    return name;
  }

  _disableDuplicatedSchemasStrategy(schema, aggs) {
    if (schema.name === 'group' && !aggs.segment) {
      schema.disabled = true;
    }
  }
}
