import InnerPlugin from './base';

export default class TagCloudInnerPlugin extends InnerPlugin {
  constructor(type, title, icon) {
    super('tagcloud', 'Tag cloud', 'fa-cloud');
  }

  _buildAggDefinitionStrategy(anAgg) {
    if (anAgg.schema === 'group') {
      anAgg.schema = 'segment';
    }
    return true;
  }

  _updateSchemaDefinitionStrategy(name) {
    if (name === 'group') {
      name = 'segment';
    }
    return name;
  }

  _disableDuplicatedSchemasStrategy(schema, aggs) {
    if (schema.name === 'group' && !aggs.segment) {
      schema.disabled = true;
    }
  }
}
