import 'plugins/multi_chart_vis/multi_chart_vis.less';
import 'plugins/multi_chart_vis/multi_chart_vis_controller';
import 'plugins/multi_chart_vis/multi_chart_vis_params';
import 'plugins/multi_chart_vis/multi_chart_vis_config';
import 'plugins/multi_chart_vis/multi_chart_vis_config_new';
import { VisVisTypeProvider } from 'ui/vis/vis_type';
import multiChartVisTemplate from 'plugins/multi_chart_vis/multi_chart_vis.html';
import { TemplateVisTypeProvider } from 'ui/template_vis_type/template_vis_type';
import { VisSchemasProvider } from 'ui/vis/schemas';
import { VisTypesRegistryProvider } from 'ui/registry/vis_types';

VisTypesRegistryProvider.register(MultiChartVisTypeProvider);

function MultiChartVisTypeProvider(Private) {
  const VisType = Private(VisVisTypeProvider);
  const TemplateVisType = Private(TemplateVisTypeProvider);
  const Schemas = Private(VisSchemasProvider);

  return new TemplateVisType({
    name: 'multi_chart_vis',
    title: 'Multi Chart',
    version: 1,
    icon: 'fcp-multi_chart',
    category: VisType.CATEGORY.CHARTS,
    description: 'Allows multiple types of visualizations in one.',
    template: multiChartVisTemplate,
    dashboard360Compatible: true,
    params: {
      defaults: {
      },
      editor: '<multi-chart-vis-params></multi-chart-vis-params>'
    },
    requiresSearch: false,
    schemas: new Schemas([{
      group: 'metrics',
      name: 'metric',
      title: 'Metric',
      min: 1,
      max: Infinity,
      defaults: [{
        type: 'count',
        schema: 'metric'
      }]
    }, {
      group: 'metrics',
      name: 'radius',
      title: 'Dot Size',
      min: 0,
      max: 1,
      aggFilter: ['count', 'avg', 'sum', 'min', 'max', 'cardinality']
    }, {
      group: 'buckets',
      name: 'segment',
      title: 'Segment',
      min: 0,
      max: 1,
      aggFilter: '!geohash_grid'
    }, {
      group: 'buckets',
      name: 'group',
      title: 'Split',
      min: 0,
      max: Infinity,
      aggFilter: '!geohash_grid'
    }, {
      group: 'buckets',
      name: 'split',
      title: 'Split Chart',
      min: 0,
      max: 1,
      aggFilter: '!geohash_grid'
    }])
  });
}

export default MultiChartVisTypeProvider;
