import $ from 'jquery';
import _ from 'lodash';
import angular from 'angular';
import { VisAggConfigsProvider } from 'ui/vis/agg_configs';
import { VisProvider } from 'ui/vis';
import 'ui/visualize';
import 'plugins/kibana/visualize/saved_visualizations/saved_visualizations';
import innerPlugins from './model/plugins';
import { uiModules } from 'ui/modules';
import VisStateManager from 'plugins/multi_chart_vis/state/vis_state_manager';
import { propFilter } from 'ui/filters/_prop_filter';
import 'kibi-qtip2';
import 'plugins/multi_chart_vis/directives/multi_chart_vis_options';

/*

  Multi Chart

  *** ! MAINTAINERS PLEASE READ THIS !***

  This component needs changes to kibi internal to do its work:

  PRs: 1943, 2001, 2421, 2903 (on kibi 5+), 2931, 2936, 2957, 2975, 3024 and 3027

*/
const module = uiModules.get('kibana/multi_chart_vis');

module.controller('MultiChartVisController', function ($scope, $element,
  $rootScope, Private, savedVisualizations, $timeout, $compile, getAppState, createNotifier, confirmModal) {

  const Vis = Private(VisProvider);
  const AggConfigs = Private(VisAggConfigsProvider);
  const nameFilter = propFilter('name');
  const notify = createNotifier({
    location: 'Multi Chart'
  });

  $scope.$container = $element.find('.content')[0];
  $scope.$errorContainer = $element.find('.siren-multi-chart-error')[0];
  $scope.$visCanvas = $('<div>').attr('id', 'multi-chart-vis')
    .addClass('innerVis')
    .addClass('visualize-chart').appendTo($scope.$container);

  $scope.init = 0;
  $scope.settingSelected = '';
  $scope.fetchInProgress = true;
  $scope.typeSelectorControl = true;
  $scope.configSelectorControl = true;
  $scope.circleButtonsControl = true;
  $scope.circlePos = -1;
  $scope.visStateManager = new VisStateManager();
  $scope.plugins = innerPlugins();
  $scope.configurationError = false;

  $scope.getCurrentPlugin = function () {
    return $scope.plugins[_.findIndex($scope.plugins, {'type': $scope.mode})];
  };

  $scope.$visCanvas.new = function () {
    $scope.resizeContainer();
    return $scope.$container;
  };

  $scope.$watch('esResponse', function () {
    if ($scope.init === 0) {
      $scope._setup();
      return;
    }
  });

  function updateControls(options) {
    if (_.size(options) !== 0) {
      $scope.typeSelectorControl = options.typeSelector;
      $scope.configSelectorControl = options.configSelector && $scope.visStateManager.state.settings.length > 1;
      $scope.circleButtonsControl = options.circleButtons;
    } else {
      $scope.typeSelectorControl = true;
      $scope.configSelectorControl = $scope.visStateManager.state.settings.length > 1;
      $scope.circleButtonsControl = true;
    }
  }

  $scope.$watch('visStateManager.state.settings.length', () => {
    updateControls($scope.vis.getUiState().get('options'));
  });

  $scope.sortSettings = (setting) => {
    if (setting.name) {
      return setting.name.toLowerCase();
    };
  };

  $scope.indexToDelete;
  $scope.delete = (idx) => {
    const index = idx || $scope.indexToDelete;
    $scope.visStateManager.deleteSetting(index);
    if ($scope.displayErrorMessage) {
      $scope.displayErrorMessage = false;
      $scope.configurationError = false;
      $scope.indexToDelete = null;
    };
    $scope.settingSelected = $scope.visStateManager.activeSetting.name;
  };

  $scope.circleMenu = function (direction) {
    const sortedSettingsArray = _.sortBy($scope.visStateManager.state.settings, $scope.sortSettings);
    const index = _.findIndex(sortedSettingsArray, 'name', $scope.settingSelected);
    if (direction > 0) {
      $scope.circlePos = index + 1;
      if ($scope.circlePos === sortedSettingsArray.length) {
        $scope.circlePos = 0;
      }
    } else {
      $scope.circlePos = index - 1;
      if ($scope.circlePos < 0) {
        $scope.circlePos = sortedSettingsArray.length - 1;
      }
    }
    $scope.settingSelected = sortedSettingsArray[$scope.circlePos].name;
  };

  // Initialize the inner visualization in the two different modes (visualize/dashboard)
  $scope._setup = function () {
    if ($scope.vis._editableVis) {
      if (_.size($scope.vis._editableVis.kibiSettings) === 0) {
        $scope.visStateManager.clearState();
        $scope.vis._editableVis.kibiSettings = $scope.visStateManager.state;
      }
      $scope.visStateManager.state = $scope.vis._editableVis.kibiSettings;

      $scope.vis._editableVis.visStateManager = $scope.visStateManager;

      $scope.prevState = $scope.vis.getUiState().get('options');
      updateControls($scope.prevState);

      const uiStateActiveSetting = $scope.vis.getUiState().get('activeSetting');
      const uiStateActiveMode = $scope.vis.getUiState().get('activeMode');
      if (uiStateActiveSetting && $scope.visStateManager.settings.all.byName[uiStateActiveSetting]) {
        $scope.visStateManager.activeSetting = uiStateActiveSetting;
      }
      if (uiStateActiveMode && $scope.visStateManager.activeSetting) {
        $scope.visStateManager.activeSetting.activeMode = uiStateActiveMode;
      }
      if ($scope.visStateManager.activeSetting) {
        $scope.mode = $scope.visStateManager.activeSetting.activeMode;
        $scope.displayErrorMessage = false;
        try {
          $scope.vis.aggs = new AggConfigs($scope.vis, $scope.visStateManager.activeSetting.aggs);
          $scope.vis._editableVis.aggs = new AggConfigs($scope.vis._editableVis, $scope.visStateManager.activeSetting.aggs);
        }
        catch (err) {
          if (err.savedObjectType === 'index-pattern-field') {
            $scope.configurationError = true;
            const configNames = $scope.visStateManager.settings.map((item) => {
              return item.name;
            });
            $scope.indexToDelete = configNames.indexOf($scope.visStateManager.activeSetting.name);
            $scope.multichartErrorMessage = 'This configuration was changed or removed from index pattern';
          } else {
            notify.error(err.message);
            $scope.multichartErrorMessage = err.message;
          };
          $scope.displayErrorMessage = true;
        }
        $scope.init = 1;
        const uiState = $scope.vis.getUiState().createChild(
          'settings.' + $scope.visStateManager.activeSetting.name + '.filters', {}, true);
        const filters = uiState.get('filters');
        const query = uiState.get('query');
        const appState = getAppState();
        appState.filters = filters ? filters : [];
        appState.query = query ? query : {
          query_string: {
            analyze_wildcard: true,
            query: '*'
          }
        };
        appState.save();
      } else {
        $scope.init = 1;
      };

      $scope.$on('fetch', function () {
        const appState = getAppState();
        const uiState = $scope.vis.getUiState().createChild('settings.' + $scope.visStateManager.activeSetting.name + '.filters', {}, true);

        $scope.vis.getUiState().removeChild('settings.' + $scope.visStateManager.activeSetting.name + '.filters.query');
        uiState.set('query', appState.query);

        $scope.vis.getUiState().removeChild('settings.' + $scope.visStateManager.activeSetting.name + '.filters.filters');
        uiState.set('filters', appState.filters);

        $timeout(() => {
          $scope.loadVis($scope.mode);
        });
      });

      $scope.$watch('vis._kibiSavedVis.type', value => {
        if ($scope.vis._kibiSavedVis && value !== 'multi_chart_vis') {
          $scope.vis._kibiSavedVis.type = 'multi_chart_vis';
        }
      });

      $scope.vis._kibiBeforeTransferState = (fromVis, toVis, stage) => {
        if (stage && $scope.visStateManager.activeSetting) {
          const modeParams = _.cloneDeep($scope.vis._editableVis.params);
          $scope.visStateManager.addMode($scope.visStateManager.activeSetting.name, $scope.mode, modeParams);
          $scope.visStateManager.activeSetting.aggs = $scope.vis._editableVis.aggs.map(function (agg) {
            return agg.toJSON();
          });
          $scope.vis.kibiSettings = $scope.visStateManager.state;
          $scope.vis._kibiSavedVis.type = 'multi_chart_vis';
        }
      };

      $scope.$watch('vis._editableVis.dirty', (dirty, oldDirty) => {
        if (dirty !== oldDirty && !dirty) {
          $scope.loadVis($scope.mode);
        }
      });

      $scope.$watchCollection('vis.params', function (newValue, oldValue) {
        updateControls($scope.vis.getUiState().get('options'));
      });

      if ($scope.visStateManager.activeSetting) {
        $scope.settingSelected = $scope.visStateManager.activeSetting.name;
      };

      function refreshSelection(settingName) {
        const state = $scope.visStateManager.settings.all.byName[settingName];
        $scope.displayErrorMessage = false;
        try {
          $scope.vis.aggs = new AggConfigs($scope.vis, state.aggs);
          $scope.vis._editableVis.aggs = new AggConfigs($scope.vis._editableVis, state.aggs);
        }
        catch (err) {
          if (err.savedObjectType === 'index-pattern-field') {
            $scope.configurationError = true;
            const configNames = $scope.visStateManager.settings.map((item) => {
              return item.name;
            });
            $scope.indexToDelete = configNames.indexOf(settingName);
            $scope.multichartErrorMessage = 'This configuration was changed or removed from index pattern';
          } else {
            notify.error(err.message);
            $scope.multichartErrorMessage = err.message;
          };
          $scope.displayErrorMessage = true;
          $scope.vis.aggs = {};
          $scope.vis._editableVis.aggs = {};
        }
        $scope.visStateManager.activeSetting = settingName;
        $scope.loadVis($scope.visStateManager.activeSetting.activeMode);
        $scope._saveState();
        $scope.vis.getUiState().set('activeSetting', $scope.visStateManager.activeSetting.name);

        const uiState = $scope.vis.getUiState().createChild(
          'settings.' + $scope.visStateManager.activeSetting.name + '.filters', {}, true);
        const filters = uiState.get('filters');
        const query = uiState.get('query');
        const appState = getAppState();
        appState.filters = filters ? filters : [];
        appState.query = query ? query : {
          query_string: {
            analyze_wildcard: true,
            query: '*'
          }
        };
        appState.save();

        $scope.vis._editableVis.dirty = true;
      }

      // check for missing fields on visualisation's loading
      (function checkOnStart() {
        const missedFields = [];
        const settings = $scope.visStateManager.settings;
        const missedConfigurations = [];
        settings.forEach((setting) => {
          const state = settings.all.byName[setting.name];
          try {
            $scope.vis.aggs = new AggConfigs($scope.vis, state.aggs);
            $scope.vis._editableVis.aggs = new AggConfigs($scope.vis._editableVis, state.aggs);
          }
          catch (err) {
            if (err.savedObjectType === 'index-pattern-field') {
              missedConfigurations.push(setting.name);
              const missedField = _.find(setting.aggs, agg => agg.params.field).params.field;
              if (missedFields.indexOf(missedField) === -1) {
                missedFields.push(missedField);
              };
            }
          }
        });
        $scope.visStateManager.missedFields = missedFields;
        if (missedConfigurations.length > 0) {
          missedConfigurations.toString = () => {
            let string = '';
            missedConfigurations.forEach((item) => {
              string += '"' + item + '", ';
            });
            return string.slice(0, -2);
          };
          const plural1 = missedConfigurations.length > 1 ? 's' : '';
          const plural2 = missedConfigurations.length > 1 ? 'were' : 'was';
          const plural3 = missedConfigurations.length > 1 ? 'them' : 'it';
          const plural4 = missedConfigurations.length > 1 ? 'these' : 'this';
          const confirmModalOptions = {
            confirmButtonText: 'Delete ' + plural4 + ' configuration' + plural1,
            onConfirm: () => {
              const configNames = settings.map((item) => {
                return item.name;
              });
              missedConfigurations.forEach((item) => {
                $scope.visStateManager.deleteSetting(configNames.indexOf(item));
                configNames.splice(configNames.indexOf(item), 1);
              });
            }
          };
          confirmModal(
            'Field' + plural1 + ' for configuration' + plural1 + ' [' + missedConfigurations
            + '] ' + plural2 + ' removed or changed in index pattern ["' + $scope.vis.indexPattern.id
            + '"]. You can delete ' + plural3 + ' from visualization and check index pattern.',
            confirmModalOptions
          );
        }
      })();

      $scope.$on('multi_chart:change_setting', function (e, settingName) {
        $scope.settingSelected = settingName;
      });

      $scope.$watch('settingSelected', function (oldValue, newValue) {
        if (oldValue !== newValue) {
          refreshSelection($scope.settingSelected);
        }
      });

      $scope.loadVis($scope.mode);
    } else {
      savedVisualizations.get($scope.vis.id)
      .then(function (savedVis) {
        if (_.size(savedVis.visState.kibiSettings) === 0) {
          $scope.visStateManager.clearState();
          savedVis.visState.kibiSettings = $scope.visStateManager.state;
        }
        $scope.visStateManager.state = savedVis.visState.kibiSettings;

        savedVis.visState.visStateManager = $scope.visStateManager;

        $scope.prevState = $scope.vis.getUiState().get('options');
        updateControls($scope.prevState);

        const uiStateActiveSetting = $scope.vis.getUiState().get('activeSetting');
        const uiStateActiveMode = $scope.vis.getUiState().get('activeMode');
        if (uiStateActiveSetting && $scope.visStateManager.settings.all.byName[uiStateActiveSetting]) {
          $scope.visStateManager.activeSetting = uiStateActiveSetting;
        }
        const activeSetting = $scope.visStateManager.activeSetting;
        if (uiStateActiveMode) {
          $scope.visStateManager.activeSetting.activeMode = uiStateActiveMode;
        }
        $scope.mode = $scope.visStateManager.activeSetting.activeMode;
        $scope.displayErrorMessage = false;
        try {
          $scope.vis.aggs = new AggConfigs($scope.vis, activeSetting.aggs);
        }
        catch (err) {
          if (err.savedObjectType === 'index-pattern-field') {
            $scope.multichartErrorMessage = 'This configuration was changed or removed from index pattern';
          } else {
            $scope.multichartErrorMessage = err.message;
          };
          $scope.displayErrorMessage = true;
        }
        $scope.settingSelected = activeSetting.name;

        $scope.$watch('settingSelected', function (oldValue, newValue) {
          if (oldValue !== newValue) {
            $scope.circlePos = _.findIndex($scope.visStateManager.settings, {name: $scope.settingSelected});
            const setting = $scope.visStateManager.settings.all.byName[$scope.settingSelected];
            $scope.displayErrorMessage = false;
            try {
              $scope.vis.aggs = new AggConfigs($scope.vis, setting.aggs);
            }
            catch (err) {
              if (err.savedObjectType === 'index-pattern-field') {
                $scope.multichartErrorMessage = 'This configuration was changed or removed from index pattern';
              } else {
                $scope.multichartErrorMessage = err.message;
              };
              $scope.displayErrorMessage = true;
            }
            $scope.visStateManager.activeSetting = $scope.settingSelected;
            $scope.vis.getUiState().set('activeSetting', $scope.settingSelected);
            $scope.loadVis(setting.activeMode);

            const uiState = $scope.vis.getUiState().createChild(
              'settings.' + $scope.visStateManager.activeSetting.name + '.filters', {}, true);
            const filters = uiState.get('filters');
            const query = uiState.get('query');
            $scope.searchSource._state.filter = filters ? filters : [];
            $scope.searchSource._state.query = query ? query : {
              query_string: {
                analyze_wildcard: true,
                query: '*'
              }
            };
          }
        });

        $scope.init = 1;
        $scope.resizeContainer(10);
        $timeout(() => {
          $scope.resizeContainer();
        });
        $scope.loadVis($scope.mode);
      });
    }
  };

  // Saves the setting/mode state inside of params vis property.
  $scope._saveState = function () {
    const radiusRatioParam = _.pick($scope.vis._editableVis.params, 'radiusRatio');

    const modeParams = _.assign(_.omit($scope.vis.params, '_state'), radiusRatioParam);
    $scope.visStateManager.addMode($scope.visStateManager.activeSetting.name, $scope.mode, modeParams);
    $scope.visStateManager.activeSetting.aggs = $scope.vis.aggs.map(function (agg) {
      return agg.toJSON();
    });

    $scope.vis._editableVis.kibiSettings = $scope.visStateManager.state;
    $scope.vis.kibiSettings = $scope.visStateManager.state;
  };

  // creates the inner visualization object
  $scope._createInnerVisObj = function (type) {
    // Get the current inner visualization state
    let state = {
      type: type,
      params: {},
      requiresSearch: true
    };
    if ($scope.visStateManager.activeSetting.modes[$scope.mode]) {
      state = $scope.visStateManager.activeSetting.modes[$scope.mode];
    }

    return new Vis($scope.vis.indexPattern, state);
  };

  function isAggFiltered(type, filters) {
    const filtered = nameFilter([type], filters);
    return filtered.length === 0;
  }

  // Build the aggregation definition for the inner visualization
  $scope._buildAggDefinition = function (vis, schemaState) {
    const currentPlugin = $scope.getCurrentPlugin();
    vis.aggs = new AggConfigs(vis, $scope.vis.aggs.map(function (agg) {
      let anAgg = agg.toJSON();
      if (!currentPlugin.buildAggDefinition(anAgg, schemaState)) {
        return false;
      }
      return anAgg;
    }).filter(Boolean));
    $scope.displayAggErrorMessage = false;
    _.each(vis.aggs, agg => {
      if (isAggFiltered(agg.type, agg.schema.aggFilter)) {
        $scope.displayAggErrorMessage = true;
      }
    });
  };

  // Updates schema details of aggregations in use
  $scope._updateCurrentSchemaDefinition = function (vis) {
    _.each($scope.vis._editableVis.aggs, agg => {
      const innerVisAgg = vis.aggs.byId[agg.id];
      if (!innerVisAgg) {
        agg.disabled = true;
      } else {
        if (innerVisAgg.schema && !isAggFiltered(agg.type, innerVisAgg.schema.aggFilter)) {
          agg.schema.title = innerVisAgg.schema.title;
          agg.schema.icon = innerVisAgg.schema.icon;
          agg.schema.aggFilter = innerVisAgg.schema.aggFilter;
          agg.disabled = false;
        } else {
          agg.disabled = true;
        }
      }
    });
  };

  // Updates schema details of all schemas type defnitions
  $scope._updateSchemaDefinition = function (vis, schemaState) {
    const currentPlugin = $scope.getCurrentPlugin();
    _.each($scope.vis._editableVis.type.schemas.all.raw, schema => {
      let name = currentPlugin.updateSchemaDefinition(schema.name, schemaState);
      const innerVisSchema = vis.type.schemas.all.byName[name];
      if (!innerVisSchema) {
        schema.disabled = true;
      } else {
        schema.disabled = false;
        schema.title = innerVisSchema.title;
        schema.icon = innerVisSchema.icon;
        schema.aggFilter = innerVisSchema.aggFilter;
      }
    });
  };

  // Disables duplicated schemas and for line/bar/area restricts the group schema count
  $scope._disableDuplicatedSchemas = function () {
    const currentPlugin = $scope.getCurrentPlugin();
    _.each($scope.vis._editableVis.type.schemas.all.raw, schema => {
      currentPlugin.disableDuplicatedSchemas(schema, $scope.vis._editableVis.aggs.bySchemaName);
    });
  };

  //creates the visualize for the new inner visualization
  $scope._createInnerVisContainer = function (vis) {
    $($scope.$container).empty();

    vis.listeners.click = (o) => {
      $scope.vis.listeners.click(o);
      if (o.value !== undefined) {
        $timeout(() => {
          $scope.loadVis($scope.mode);
        });
      }
    };

    vis.listeners.brush = (o) => {
      $scope.vis.listeners.brush(o);
      $timeout(() => {
        $scope.loadVis($scope.mode);
      });
    };

    $scope.innerUIState = $scope.uiState.createChild(
      'settings.' + $scope.visStateManager.activeSetting.name + '.' + $scope.mode, {}, true);

    let $cont = $scope.$visCanvas.new();
    let editable = '';
    if ($scope.vis._editableVis) {
      editable = ' editable-vis="iEditableVis" ';
    }
    let $el = $('<visualize vis="iVis" ' + editable +
    ' ui-state="innerUIState" search-source="searchSource" show-spy-panel="true">').appendTo($cont);
    if ($scope.$newScope) {
      $scope.$newScope.$destroy();
    }
    $scope.$newScope = $scope.$new();
    $compile($el)($scope.$newScope);

    $scope.$newScope.$watch('vis._kibiSavedVis.type', value => {
      if ($scope.vis._kibiSavedVis && value !== 'multi_chart_vis') {
        $scope.vis._kibiSavedVis.type = 'multi_chart_vis';
      }
    });

    $scope.iVis.esResponseAdapter = function (resp) {
      if ($scope.fetchInProgress) {
        $timeout(() => {
          $scope.resizeContainer();
          $scope.fetchInProgress = false;
        });
      }
      return resp;
    };

    $scope.iVis.$$sirenMultichart = true;
    $scope.iVis.$$sirenSingleCall = true;
  };

  $scope.selectVis = function (mode) {
    $scope.mode = mode;
    $timeout(() => {
      $scope.loadVis(mode);
    });
  };


  $scope.$watch('vis._siren', function () {
    if ($scope.iVis) {
      $scope.iVis._siren = $scope.vis._siren;
    }
  });

  // loads a inner-visualization
  $scope.loadVis = function (type) {
    if (!$scope.init || !$scope.visStateManager.activeSetting) {
      return;
    }
    $scope.mode = type;
    $scope.visStateManager.activeMode = $scope.mode;
    $scope.vis.getUiState().set('activeMode', $scope.mode);

    let vis = $scope._createInnerVisObj(type);

    const schemaState = {
      groupCount: 0,
      segmentCount: 0,
      groupMaxReached: false,
      segmentMaxReached: false
    };

    $scope._buildAggDefinition(vis, schemaState);

    if ($scope.vis._editableVis) {
      $scope._updateCurrentSchemaDefinition(vis);
      $scope._updateSchemaDefinition(vis, schemaState);
      $scope._disableDuplicatedSchemas();
    }

    if (_.size($scope.visStateManager.activeMode.params) !== 0) {
      vis.params = _.cloneDeep($scope.visStateManager.activeMode.params);
    } else {
      $scope.visStateManager.activeMode.params = _.cloneDeep(vis.params);
    }
    $scope.vis.params = _.cloneDeep(vis.params);

    const iVis = vis;
    if ($scope.vis._siren) {
      iVis._siren = $scope.vis._siren
    }
    $scope.iVis = iVis;

    if ($scope.vis._editableVis) {
      $scope.vis._editableVis.params = _.cloneDeep(vis.params);
      $scope.iEditableVis = vis.createEditableVis();
    }

    $scope.vis.type.params = _.cloneDeep(vis.type.params);

    $scope.fetchInProgress = true;
    $scope._createInnerVisContainer(vis);
  };

  $scope.resizeContainer = function (offset = 0) {
    let h = $element.height()
          - $element.find('.command-bar')[0].offsetHeight
          - 3 - offset;
    if (h < 20) h = 20;
    $($scope.$container).height(h);
    $($scope.$errorContainer).height(h);
    $('.siren-multi-chart-error-inner').css('margin-top', h/2 - 30 + 'px');
    $('.empty_content').css('min-height', h + 'px');
  };

  function onSizeChange() {
    return {
      width: $element.parent().width(),
      height: $element.parent().height()
    };
  }

  $scope.$watch(onSizeChange, _.debounce(function () {
    $scope.resizeContainer();
  }, 250), true);

  const resizeHandlerMultichart = function () {
    $scope.resizeContainer();
  };
  // Re-render if the window is resized
  angular.element(window).on('resize', resizeHandlerMultichart);

  const uiState = $scope.vis.getUiState();

  const uiStateHandler = function () {
    if ($scope.vis._editableVis && !_.eq($scope.prevState, uiState.get('options'))) {
      $scope.prevState = uiState.get('options');
      $scope.vis._editableVis.dirty = true;
    }
  };

  uiState.on('set', uiStateHandler);

  $scope.$on('$destroy', function () {
    $scope.$newScope.$destroy();
    $scope.plugins = null;
    angular.element(window).off('resize', resizeHandlerMultichart);
    uiState.off('set', uiStateHandler);
  });

  // UI options editor (show/hide of buttons/combo)
  $scope.initOptionEditor = function () {
    $scope.optionUpdated = () => {
      updateControls($scope.vis.getUiState().get('options'));
      // Waits a litle to allow resize event take place
      $timeout(() => {
        $scope.resizeContainer(10);
        $scope.resizeContainer();
      });
    };

    // injects a directive to manage the ui vis options
    const $selector = $($element.find('.siren-multi-chart-btn-options')[0]);
    $selector.qtip('destroy', true);
    const html = '<multi-chart-vis-options' +
                 ' vis="vis"' +
                 ' updated="optionUpdated()"' +
                 ' settings="visStateManager.state.settings.length"' +
                 ' typeSelector="typeSelector"' +
                 ' configSelector="configSelector"' +
                 ' circleButtons="circleButtons"' +
                 '></multi-chart-vis-options>';
    const tooltips = $selector.qtip({
      content: {
        text: $compile(html)($scope)
      },
      position: {
        my: 'bottom left',
        at: 'top right',
        adjust: {
          x: -10,
          y: 2
        }
      },
      show: {
        event: 'click'
      },
      hide: {
        event: 'unfocus click'
      },
      style: {
        classes: 'siren-multi-chart-options',
        tip: {
          corner: false
        }
      }
    });
  };

  $scope.initOptionEditor();
});
