import _ from 'lodash';

export default function compareFields(visState) {
  const state = function () {
    if (!visState._editableVis.visStateManager) {
      return {
        state: {}
      };
    } else {
      return visState._editableVis.visStateManager;
    }
  };
  const ip = visState.indexPattern;
  const metaFields = ip.metaFields;
  const actualFields = ip.fields.byName;
  const fieldsToAdd = [];
  const indexesToDelete = [];
  const stateFields = state().state.settings;
  let addedCount = 0;
  let removedCount = 0;
  const stateFieldNames = stateFields.map((field) => {
    if (field.aggs && field.aggs.length > 1) {
      return field.aggs[1].params.field;
    }
  });
  if (stateFieldNames[0] === 'default') {
    stateFieldNames.slice(1);
  };
  const actualFieldsNames = Object.keys(actualFields);
  _.each(actualFields, field => {
    if (field.visualizable && !_.includes(metaFields, field.name) && !field.name.endsWith('.geohash')) {
      if (stateFieldNames.indexOf(field.name) === -1) {
        fieldsToAdd.push(field);
        addedCount++;
      }
    }
  });
  _.each(stateFields, (savedField, index) => {
    if (savedField.aggs && savedField.aggs.length > 1) {
      if (!_.includes(metaFields, savedField.aggs[1].params.field) && actualFieldsNames.indexOf(savedField.aggs[1].params.field) === -1
      && savedField.name !== 'default') {
        indexesToDelete.push(index);
        removedCount++;
      }
    } else {
      indexesToDelete.push(index);
      removedCount++;
    };
  });
  indexesToDelete.reverse();
  return {
    indexesToDelete,
    fieldsToAdd,
    addedCount,
    removedCount
  };
};