export default {
  generateCopyName: (configState, name) => {
    const originName = name || configState.activeSetting.name;
    const allConfigNames = configState.state.settings.map(setting => {
      return setting.name;
    });
    const copyId = (rule) => {
      let id = -1;
      allConfigNames.forEach(name => {
        if (name.indexOf(rule) !== -1) id++;
      });
      return id;
    };
    const nameWithSkippedCopyId = (name) => {
      const allCopyIndexes = [];
      const subName = name.slice(0, -3);
      allConfigNames.forEach(name => {
        if (name.indexOf(subName) !== -1) {
          let stringId = name.slice(-9).split('#')[1];
          if (stringId) {
            let id = Number(stringId.slice(0, -1));
            allCopyIndexes.push(id);
          };
        };
      });
      let id = 0;
      allCopyIndexes.sort((a, b) => {
        if (a > b) return 1;
        if (a < b) return -1;
      });
      for(let i = 0; i < allCopyIndexes.length; i++) {
        ++id;
        if (id !== allCopyIndexes[i]) break;
      };
      const firstName = name.slice(0, -5);
      const secondName = name.slice(-5).split('#');
      return firstName + secondName[0] + '#' + id + ')';
    };
    let newName;
    if (originName.slice(-6) === '(copy)') {
      let id = copyId(originName.slice(0, -5));
      newName = originName.slice(0, -1) + ' #' + ++id + ')';
    } else if (originName.slice(-10).indexOf('(copy #') !== -1 && originName.slice(-1) === ')') {
      let id = copyId(originName.slice(0, -5));
      if (!!id && id > 0) {
        const firstName = originName.slice(0, -5);
        const secondName = originName.slice(-5).split('#');
        newName = firstName + secondName[0] + '#' + ++id + ')';
      } else {
        newName = originName + ' (copy)';
      }
    } else {
      if (allConfigNames.indexOf(originName + ' (copy)') !== -1) {
        const ruleId = originName + ' (copy';
        const id = copyId(ruleId) + 1;
        newName = originName + ' (copy #' + id + ')';
      } else {
        newName = originName + ' (copy)';
      } 
    };
    if (allConfigNames.indexOf(newName) !== -1) {
      newName = nameWithSkippedCopyId(newName);
    }
    return newName;    
  },
  namesConflict: (name, configState) => {
    const allConfigNames = configState.state.settings.map(setting => {
      return setting.name;
    });
    return allConfigNames.indexOf(name) !== -1;
  }
}