import { uiModules } from 'ui/modules';

const module = uiModules.get('kibana/multi_chart_vis');

module.service('multiChartSDCQuery', function (es) {
  class SDCQuery {
    search(index, body) {
      return es.search({
        index: index,
        ignore_unavailable: true,
        body: body
      });
    }

    searchAgg(index, aggs) {
      return this.search(index, {
        size: 1,
        query: {
          bool: {
            must: [{
              query_string: {
                query: '*',
                analyze_wildcard: true
              }
            }],
            must_not: []
          }
        },
        _source: {
          excludes: []
        },
        aggs: aggs
      });
    }

    searchRandom(index, field, size) {
      return this.search(index, {
        size: size,
        query: {
          function_score: {
            boost_mode: 'replace',
            functions: [{
              random_score: {}
            }],
            query: {
              bool: {
                must: [{
                  query_string: {
                    query: '*',
                    analyze_wildcard: true
                  }
                }, {
                  exists: {
                    field: field.name
                  }
                }],
                must_not: []
              }
            }
          }
        },
        _source: [field.name]
      });
    }
  }

  return new SDCQuery();
});
