export default class StopWatch {
  constructor(study, context) {
    this.study = study;
    this.context = context;
  }

  start() {
    if (console.debug) {  // eslint-disable-line no-console
      console.debug(this.study, this.context, 'start');  // eslint-disable-line no-console
    }
    this.startTime = new Date();
  }

  stop() {
    this.endTime = new Date();
    this.log();
  }

  get elapsed() {
    const timeDiff = this.endTime - this.startTime; //in ms
    return timeDiff / 1000;
  }

  log() {
    if (console.debug) {  // eslint-disable-line no-console
      console.debug(this.study, this.context, this.elapsed);  // eslint-disable-line no-console
    }
  }
}