import '../parallel_lines_chart_vis';

import { VisProvider } from 'ui/vis';
import { VisAggConfigsProvider } from 'ui/vis/agg_configs';

import parallelHtml from '../parallel_vis.html';

import { stubbedLogstashIndexPatternService }
  from 'fixtures/stubbed_logstash_index_pattern';
import { aggs, response } from './parallel_query_example.js';

import ngMock from 'ng_mock';
import expect from 'expect.js';
import $ from 'jquery';
import _ from 'lodash';


describe('Parallel Lines', function () {
  let Vis;
  let AggConfigs;

  let vis;
  let $scope;
  let $element;
  let Private;


  beforeEach(function loadVis() {
    ngMock.module('kibana');

    ngMock.inject(function ($injector, Private) {
      Vis = Private(VisProvider);
      AggConfigs = Private(VisAggConfigsProvider);

      const indexPattern = Private(stubbedLogstashIndexPatternService);
      vis = new Vis(indexPattern, {
        type: 'parallel_lines_chart_vis'
      });
    });
  });

  beforeEach(function loadController() {
    ngMock.inject(function ($rootScope, $controller) {
      $element = $(parallelHtml);
      $element.appendTo('body');

      $scope = $rootScope.$new();
      $scope.vis = vis;

      $controller('ParallelLinesChartVisController', { $scope, $element });

      $scope.$digest();
    });
  });

  afterEach(() => $element.remove());


  it('vis is correctly instantiated', function () {
    expect(vis.type.name).to.be('parallel_lines_chart_vis');
  });

  it('vis can render a simple response', function () {
    vis.params.useCanvas = false;                 // We want to count lines

    vis.aggs = new AggConfigs(vis, aggs);
    $scope.esResponse = response;

    $scope.$digest();

    const recordsCount = _.sum(response.aggregations['2'].buckets,
      bucket => bucket['3'].buckets.length);

    expect($element.find('.plg-column').length).to.be(aggs.length);
    expect($element.find('.parallel-chart-svg path').length)
      .to.be(recordsCount);
  });
});
