
import _ from 'lodash';


export function assert(value, message) {
  if (!value) { throw new Error(message || 'Assert Failed'); }
}

export function moveIndex(index, srcIdx, dstIdx) {
  if (index === srcIdx) { return dstIdx; }
  if (srcIdx < index && index <= dstIdx) { return index - 1; }
  if (dstIdx <= index && index < srcIdx) { return index + 1; }
  return index;
}

export function arrayMoveValue(arr, srcIdx, dstIdx) {
  arr.splice(dstIdx, 0, arr.splice(srcIdx, 1)[0]);
}

function valueAt(idx, arr) { return arr[idx]; }

export function lowerBound(arr, val, iter = valueAt) {
  let lo = 0;
  let mid;
  let hi = arr.length;

  while (lo < hi) {
    mid = (lo + hi) >>> 1;
    val <= iter(mid, arr) ? hi = mid : lo = mid + 1;
  }

  return lo;
}

export function upperBound(arr, val, iter = valueAt) {
  let lo = 0;
  let mid;
  let hi = arr.length;

  while (lo < hi) {
    mid = (lo + hi) >>> 1;
    val < iter(mid, arr) ? hi = mid : lo = mid + 1;
  }

  return lo;
}

export function paddedIp(ip) {
  let sep;
  let charsCount;

  if (ip[1] === '.' || ip[2] === '.' || ip[3] === '.') {
    sep = '.';
    charsCount = 3;
  } else {
    sep = ':';
    charsCount = 4;
  }

  return _(ip)
    .split(sep)
    .map(chars => _.padLeft(chars, charsCount, '0'))
    .join(sep);
}

export function truncateTextAtWidth(width, ellipsis = '...') {
  function withEllipsis(str) { return str + ellipsis; }

  return function (node) {
    const allText = node.textContent;
    if (node.getComputedTextLength() <= width) { return; }

    const end = upperBound(allText, width, function widthAt(pos) {
      node.textContent = withEllipsis(allText.slice(0, pos));
      return node.getComputedTextLength();
    }) - 1;

    node.textContent = withEllipsis(allText.slice(0, Math.max(0, end)));
  };
}

