export default function (kibana) {

  const migrations = [
    require('./lib/migrations/migrations_5/migration_1')
  ];

  return new kibana.Plugin({
    name: 'scatterplot_vis',
    require: ['kibana', 'elasticsearch', 'migrations'],
    uiExports: {
      visTypes: [
        'plugins/scatterplot_vis/scatterplot_vis'
      ]
    },
    preInit: function (server, kbnServer) {
      // Expose the migrations on kbnServer
      // use this.pkg.name because 'this' points to ScopedPlugin not this object
      kbnServer.migrations[this.pkg.name] = migrations;
    }
  });
};
