'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = backupCommand;

var _lodash = require('lodash');

var _read_yaml_config = require('../serve/read_yaml_config');

var _read_yaml_config2 = _interopRequireDefault(_read_yaml_config);

var _from_root = require('../../utils/from_root');

var _backup_kibi = require('./_backup_kibi');

var _backup_kibi2 = _interopRequireDefault(_backup_kibi);

var _syswideCas = require('syswide-cas');

var _syswideCas2 = _interopRequireDefault(_syswideCas);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * The command to backup a kibi instance
 */
function backupCommand(program) {

  async function backup(options) {
    const config = (0, _read_yaml_config2.default)(options.config);

    if (options.dev) {
      try {
        (0, _lodash.merge)(config, (0, _read_yaml_config2.default)((0, _from_root.fromRoot)('config/investigate.dev.yml')));
      } catch (e) {
        // ignore
      }
    }

    if ((0, _lodash.has)(config, 'elasticsearch.ssl.ca')) {
      _syswideCas2.default.addCAs((0, _lodash.get)(config, 'elasticsearch.ssl.ca'));
    }

    let exitCode = 0;
    if (!options.backupDir) {
      process.stderr.write('Backup directory was not specified.\n');
      return process.exit(1);
    }
    try {
      const backupKibi = new _backup_kibi2.default(config, options.backupDir);
      await backupKibi.backup();
    } catch (error) {
      process.stderr.write(`${error}\n`);
      exitCode = 1;
    }

    process.exit(exitCode);
  }

  async function processCommand(options) {
    await backup(options);
  }

  program.command('backup').description('Backup an Investigate instance').option('--dev', 'Run the backup using development mode configuration').option('-c, --config <path>', 'Path to the config file, can be changed with the CONFIG_PATH environment variable as well', process.env.CONFIG_PATH || (0, _from_root.fromRoot)('config/investigate.yml')).option('--backup-dir <path>', 'Path to the directory where the Investigate instance data is saved').action(processCommand);
};
module.exports = exports['default'];
