'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensureEsVersion = ensureEsVersion;

var _lodash = require('lodash');

var _setup_error = require('./setup_error');

var _setup_error2 = _interopRequireDefault(_setup_error);

var _utils = require('../../../utils');

var _common = require('../../../siren_core_plugins/federate_resolver/common');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

//kibi: imports - End
/**
 * tracks the node descriptions that get logged in warnings so
 * that we don't spam the log with the same message over and over.
 *
 * There are situations, like in testing or multi-tenancy, where
 * the server argument changes, so we must track the previous
 * node warnings per server
 */
/**
 * ES and Kibana versions are locked, so Kibana should require that ES has the same version as
 * that defined in Kibana's package.json.
 */

const lastWarnedNodesForServer = new WeakMap();
//kibi: imports - Start
function ensureEsVersion(server, kibiVersion, clusterName = 'admin') {
  // kibi: kibiVersion added to properly report Kibi version
  const { callWithInternalUser } = server.plugins.elasticsearch.getCluster(clusterName);

  server.log(['plugin', 'debug'], 'Checking Elasticsearch version');
  return callWithInternalUser('nodes.info', {
    filterPath: ['nodes.*.version', 'nodes.*.http.publish_address', 'nodes.*.ip', 'nodes.*.plugins']
  }).then(function (info) {
    // Aggregate incompatible ES nodes.
    const compatibilityResolver = new _common.CompatibilityResolver(info.nodes, _utils.pkg.siren.compatibility);
    const incompatibleNodes = compatibilityResolver.getIncompatibleNodes();

    function getHumanizedNodeNames(nodes) {
      return nodes.map(({ node, reason }) => {
        const publishAddress = (0, _lodash.get)(node, 'http.publish_address') ? (0, _lodash.get)(node, 'http.publish_address') + ' ' : '';
        return `v${node.version} @ ${publishAddress}(${node.ip}) || ${reason}`;
      });
    }

    if (incompatibleNodes.length) {
      const incompatibleNodeNames = getHumanizedNodeNames(incompatibleNodes);

      //kibi: changed the message
      const errorMessage = `Siren Investigate ${kibiVersion} requires all nodes to pass the compatibility matrix. ` + `The following incompatible nodes were found in your cluster: \n${incompatibleNodeNames.join(' -- \n')}`;

      throw new _setup_error2.default(server, errorMessage);
    }

    return true;
  });
}
