import PropTypes from 'prop-types';
import React, { Component } from 'react';
import Select from 'react-select';
import { htmlIdGenerator } from '@elastic/eui';

export class IndexPatternSelect extends Component {
  constructor(props) {
    super(props);

    this.loadOptions = this.loadOptions.bind(this);
    this.resetOptions = this.resetOptions.bind(this);
    this.selectOption = this.selectOption.bind(this);
  }

  loadOptions(input, callback) {
    this.props.getIndexPatterns(input).then((indexPatternSavedObjects) => {
      const options = indexPatternSavedObjects.map((indexPatternSavedObject) => {
        return {
          label: indexPatternSavedObject.attributes.title,
          value: indexPatternSavedObject.id
        };
      });
      callback(null, { options: options });
    });
  }

  // kibi: added to reset selected options to whole list of options
  resetOptions() {
    this.refs.asyncIndexSelector.loadOptions('');
  };

  selectOption(option) {
    this.props.onChange(option);
    this.refs.asyncIndexSelector.loadOptions('');
  }
  // kibi: end

  render() {
    const idGenerator = htmlIdGenerator();
    const selectId = idGenerator('indexPatternSelect');
    return (
      <div className="kuiSideBarFormRow">
        <label className="kuiSideBarFormRow__label" htmlFor={ selectId }>
          Index Pattern
        </label>
        <div className="kuiSideBarFormRow__control kuiFieldGroupSection--wide">
          <Select.Async
            className="index-pattern-react-select"
            placeholder="Select index pattern..."
            value={ this.props.value }
            loadOptions={ this.loadOptions }
            // kibi: added 'ref' and 'onBlur' and changed 'onChange'
            // to reset selected options to whole list of options
            ref="asyncIndexSelector"
            onBlur={ this.resetOptions }
            onChange={ this.selectOption }
            // kibi: end
            resetValue={ '' }
            inputProps={{ id: selectId }}
          />
        </div>
      </div>
    );
  }
}

IndexPatternSelect.propTypes = {
  getIndexPatterns: PropTypes.func.isRequired,
  onChange: PropTypes.func.isRequired,
  value: PropTypes.string
};
