import { notify } from 'ui/notify';

export function SetEntityAndIndexpatternOnDashProvider(ontologyModel, savedSearches) {
  return function setEntityAndIndexPatternOnDash(dash, entityId) {
    return ontologyModel.getEntityMap()
      .then(entityMap => {
        if (!entityMap[entityId]) {
        // kibi: if there is no savedSearchId in the entityMap that means savedSearch is broken
        // we retrieve all savedSearches with `ignoreBroken = true`, get the title then show it in the notify
          return savedSearches.find('', true, 100, false, true)
            .then(savedSearches => {
              let savedSearch;
              for (let i = 0; i < savedSearches.hits.length; i++) {
                if (savedSearches.hits[i].id === entityId) {
                  savedSearch = savedSearches.hits[i];
                  break;
                }
              }
              if (savedSearch) {
                throw new Error(
                  savedSearch.title + ' (id: "' + entityId + '") Index Pattern Search not found. ' +
                'Check the configuration of your Data model or review your Dashboard Relations on edit mode.'
                );
              } else {
                throw new Error(
                  entityId + ' Index Pattern Search not found. ' +
                'Check the configuration of your Data model or review your Dashboard Relations on edit mode.'
                );
              }
            });
        }
        dash.entity = entityMap[entityId];
        dash.indexPattern = dash.entity._objects.indexPattern;
        return dash;
      })
      .catch(error => {
        // kibi: we should let user go to the dashboard, user should be able to edit dashboard
        notify.error(error);
        return dash;
      });
  };
}
