import _ from 'lodash';
import 'ui/notify';
import { uiModules } from 'ui/modules';


const module = uiModules.get('discover/saved_eids', [
  'kibana/notify',
  'kibana/courier'
]);

module.factory('SavedEid', function (courier) {
  _.class(SavedEid).inherits(courier.SavedObject);
  function SavedEid(id) {
    courier.SavedObject.call(this, {
      type: SavedEid.type,
      mapping: SavedEid.mapping,

      id: id,
      defaults: {
        title: 'New Saved Eid',
        version: 1,
        siren: {
          ui: {
            icon: '',
            color: '',
            shortDescription: ''
          }
        }
      }
    });
  }

  SavedEid.type = 'eid';

  SavedEid.mapping = {
    title: 'string',
    version: 'integer',
    siren: {
      ui: {
        icon: 'string',
        color: 'string',
        shortDescription: 'string'
      }
    }
  };

  // Order these fields to the top, the rest are alphabetical
  SavedEid.fieldOrder = ['title'];

  return SavedEid;
});
