import 'plugins/kibana/discover/saved_eids/_saved_eid';
import 'ui/notify';
// kibi: import needed to prevent crash when plugins loaded
import 'ui/courier';
// kibi: end
import { uiModules } from 'ui/modules';
import { SavedObjectLoader } from 'ui/courier/saved_object/saved_object_loader';
import { CacheProvider } from 'ui/kibi/helpers/cache_helper';
import { savedObjectManagementRegistry } from 'plugins/kibana/management/saved_object_registry';

const module = uiModules.get('discover/saved_eids', [
  'kibana/notify'
]);

// Register this service with the saved object registry so it can be
// edited by the object editor.
savedObjectManagementRegistry.register({
  service: 'savedEids',
  title: 'eids'
});

// kibi: added Private
module.service('savedEids', function (kbnIndex, SavedEid, kbnUrl, Private, $http) {
  const options = {
    caching: {
      find: true,
      get: true,
      scanAll: true,
      cache: Private(CacheProvider)
    },
    $http
  };
  const savedEidLoader = new SavedObjectLoader(SavedEid, kbnIndex, kbnUrl, options);
  // Customize loader properties since adding an 's' on type doesn't work for type 'eid' .
  savedEidLoader.loaderProperties = {
    name: 'eids',
    noun: 'Saved Eid',
    nouns: 'saved eids'
  };
  savedEidLoader.urlFor = function (id) {
    return kbnUrl.eval('#/management/siren/datamodel/VIRTUAL_ENTITY/{{id}}', { id: id });
  };

  return savedEidLoader;
});
