import _ from 'lodash';
import 'ui/notify';
import { uiModules } from 'ui/modules';


const module = uiModules.get('apps/discover', [
  'kibana/notify',
  'kibana/courier'
]);

module.factory('IndexPattern', function (courier) {
  _.class(IndexPattern).inherits(courier.SavedObject);
  function IndexPattern(id) {
    courier.SavedObject.call(this, {
      type: IndexPattern.type,
      mapping: IndexPattern.mapping,
      searchSource: IndexPattern.searchSource,
      id: id,
    });
  }

  IndexPattern.type = 'index-pattern';

  IndexPattern.mapping = {
    title: 'string',
    timeFieldName: 'string',
    intervalName: 'string',
    mappingFormats: 'json',
    fields: 'json',
    sourceFilters: 'json',
    excludeIndices: 'boolean',
    paths: 'json', // kibi: store the path of each field, in order to support dotted field names
    fieldFormatMap:  'json'
  };

  IndexPattern.searchSource = true;

  return IndexPattern;
});
